//
//  FalconImageUtil.h
//  FalconARKitBiz
//
//  Created by taoyuan on 2017/6/23.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

@interface FalconImageUtil : NSObject
+(NSArray *)getKeyPoints:(unsigned char *)data_y refRect:(CGRect)rect imgWidth:(int)width imgHeight:(int)height;

/**
 *  根据灰度图数据生成对应识别包
 *
 *  @param data_y       灰度图数据指针
 *  @param width        灰度图宽
 *  @param height       灰度高度
 *  @param packagePath  识别包保存地址
 *
 *  @return 是否是否生成并保存成功
 */
+(BOOL)genRecPackageWithGrayData:(unsigned char *)data_y width:(int)width height:(int)height packagePath:(const char *)packagePath;

@end
