//
//  BeeImageManager.h
//  BeeUtils
//
//  Created by jinzhidong on 16/3/4.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef void (^BeeImageDownloadCompletion)(UIImage *image, NSError *error);

/**
 *  图片下载相关的管理
 */
@interface BeeImageManager : NSObject

/**
*  图片下载的接口
*
*  @param identifier 需要下载的图片url或者cloudid
*  @param business   业务存储标识
*  @param completion 完成回调
 */
+ (void)getImageWithIdentifier:(NSString *)identifier
                      business:(NSString *)business
                    completion:(BeeImageDownloadCompletion)completion;

@end
