//
//  BEETranslationUtil.h
//  BeeViews
//
//  Created by 莜阳 on 16/5/15.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import "BEETranslationModels.h"

//
typedef void(^completionVoiceToText)(VoiceToTextResult *result ,NSError *error);

@interface BEETranslationUtil : NSObject
{
    NSMutableDictionary *_completionDict;
    NSMutableDictionary *_timeDict;
    dispatch_queue_t _queue;
}

+(BEETranslationUtil *)sharInstance;

/**
 *  判断当前文案能否翻译
 *
 *  @param text 待翻译的文案
 *
 *  @return BOOL值，true认为可以翻译，否则不能翻译
 */
- (BOOL)isNeeedTranslate:(NSString *)text;

/**
 *  翻译纯文本
 *
 *  @param text 待翻译的文案
 *
 *  @param completion 翻译成功后的回调（主线程回调）
 */
- (void)translateText:(NSString *)text
           completion:(void(^)(NSString *text, TranslateRpcResult *result))completion;

/**
 *  带指定目标语言类型的翻译纯文本
 *
 *  @param text             待翻译纯文本
 *  @param targetLanguage   目标语言类型
 *  @param completion       翻译成功后的回调（主线程回调）
 */
- (void)translateText:(NSString *)text
       targetLanguage:(NSString *)targetLanguage
           completion:(void(^)(NSString *text, TranslateRpcResult *result))completion;


/**
 *  翻译语音
 *
 *  @param cloudId 语音对应的cloudId
 *
 *  @param completion 翻译成功后的回调（主线程回调）
 */
- (void)translateVoiceWithAudioId:(NSString *)audioId
                          bizType:(NSString *)bizType
                        audioType:(NSString *)audioType
                       completion:(void(^)(VoiceToTextResult *result ,NSError *error))completion;


/**
 *  取消当前语音翻译任务
 *
 *  @param cloudId 取消当前正在监听的任务
 */
- (void)cancelTranslateVoiceWithAudioId:(NSString *)audioId
                                bizType:(NSString *)bizType;
@end
