



/**
 * @desc 格式化金额为千分位(,)和小数点(.)分隔表示法
 */
NSString *amountStringFromNumber(double number);



/*这个方法不要为财富NSNumberFormatter原始状态。外部取到这个formatter按需扩展。
 *不要随意增加参数，对象纯粹性。
 */
NSNumberFormatter* WWDefaultNumberFormatter();

/**
 * @desc 根据文本内容和字体返回文本内容的大小
 */
CGSize SizeWithTextAndFont(NSString *text, UIFont *font);

// 检查输入是否合法，一般用于 - (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
//BOOL ShouldChangeAmountCharacters(NSString *originalString, NSRange range, NSString *replacementString, BOOL disableFloatAmount);


// 检查 http/https 链接，并在 APP 内打开 H5 页面（而不是独立的 H5 容器 APP）
BOOL BEEOpenUrl(NSString *url);

// 安全的打开URL，alipay/alipays将以startApp方式启动，http/https将以独立H5 App方式启动，其他url将以openUrl方式启动
BOOL BEEStartApp(NSString *urlString);


NSAttributedString* UIAttributedWithHTMLString(NSString *string,CGFloat fontSize,NSInteger defaultColor);

/**
 用户全链路转化数据埋点
 
 @param eventType 事件类型，取值有：
 1、query：查询，发起RPC请求时
 2、response：查询获取到内容，包括RPC内容和缓存内容
 3、callback：回调，返回给业务的内容
 4、show：展示，曝光的内容
 5、click：点击的内容
 6、done: 转化的内容，默认使用的是二跳页pageMonitor转化埋点
 
 @param sceneCode 场景码。投放-展位码；应用中心-限时推广；分享-业务码.
 @param contentId 内容ID。投放-创意ID；应用中心-appid；分享-分享内容ID. 注意：多条内容ID可以合并成1条，用竖线 | 间隔。
 @param bizType 业务码。投放-cdp；应用中心-OpenPlatform；分享-share
 @param extInfo 业务扩展字段。
 */
void BeeUlaLogWithEventType(NSString *eventType,NSString *sceneCode,NSString *contentId,NSString *bizType,NSDictionary *extInfo);
