//
//  BeeFilmAlbumData.h
//  BeePhotoPicker
//
//  Created by manyi.zsf on 2021/3/7.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "BEEAssetProtocol.h"

//影集数据结构
@interface BeeFilmAlbumData : NSObject

@property(nonatomic, assign) BEEAssetMediaType mediaType;   // 数据类型
@property(nonatomic, assign) NSTimeInterval duration;       // 素材在影集中的播放时长
@property(nonatomic, assign) NSTimeInterval videoDuration;  // 素材总时长
@property(nonatomic, assign) NSTimeInterval startTime;      // video的起始时间
@property(nonatomic, strong) id<BEEAssetProtocol> asset;    // 选中的asset
@property(nonatomic, strong) UIImage *thumbImage;           // 托盘缩略图
@property(nonatomic, copy) NSString *collectionKey;         // 当前素材所在相簿

@end

@interface BeeFilmAlbumEditorData : BeeFilmAlbumData

@property (nonatomic, strong) id cutInfo;
@property (nonatomic, assign) float ratio;

@end
