//
//  IBeeVideoPlayerPlugin.h
//  BeeMediaPlayer
//
//  Created by manyi.zsf on 2018/10/22.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#ifndef IBeeVideoPlayerPlugin_h
#define IBeeVideoPlayerPlugin_h

#import "BeePluginManager.h"
#import "IBeeVideoPlayer.h"
#import <APMobileNetwork/APMobileNetwork.h>

@class BeeVideoPlayerView;

typedef NS_ENUM(NSUInteger, BeeVideoPlayerAudioRouteChangeType) {
    BeeVideoPlayerAudioRouteChangeType_Add,     //新设备连接
    BeeVideoPlayerAudioRouteChangeType_Remove,  //设备断连
};

@protocol BeeVideoPlayerPluginDelegate <BeeBasePluginItem>

@optional
/**
 网络环境变化通知
 
 @param view
 @param newStatus 新的网络环境
 */
- (void)BeeVideoPlayerView:(BeeVideoPlayerView *)view netStatusChangedTo:(MPAASNetworkStatus)newStatus;
/**
 视频源初始化通知
 
 @param view
 @param src 视频源
 */
- (void)BeeVideoPlayerView:(BeeVideoPlayerView *)view initWithSrc:(NSString *)src;


/**
 点击了播放按钮， 视频加载状态

 @param view
 */
- (void)BeeVideoPlayerViewWillStartPlay:(BeeVideoPlayerView *)view;
/**
 播放器已经准备好播放了，但还没真正开始播放
 
 @param view
 */
- (void)BeeVideoPlayerViewDidReadyToPlay:(BeeVideoPlayerView *)view;

/**
 播放开始
 */
- (void)BeeVideoPlayerViewDidStartPlay:(BeeVideoPlayerView *)videoPlayer;

/**
 播放结束
 */
- (void)BeeVideoPlayerViewDidFinishPlay:(BeeVideoPlayerView *)videoPlayer;

/**
播放器的播放URL
*/
- (void)BeeVideoPlayerViewUpdateUrl:(BeeVideoPlayerView *)videoPlayer;


/**
 播放进度的回调
 
 @param videoPlayer
 @param playedTime 当前已播放时间
 */
- (void)BeeVideoPlayerView:(BeeVideoPlayerView *)videoPlayer playedTime:(NSTimeInterval)playedTime;

/**
 缓存进度的回调
 
 @param videoPlayer
 @param cachedTime 当前已缓存的时间
 */
- (void)BeeVideoPlayerView:(BeeVideoPlayerView *)videoPlayer cachedTime:(NSTimeInterval)cachedTime;

/**
 开始seek的回调
 
 @param videoPlayer
 @param seekTime seek的时间
 */
- (void)BeeVideoPlayerView:(BeeVideoPlayerView *)videoPlayer willSeekToTime:(NSTimeInterval)seekTime;

/**
 结束seek的回调
 
 @param videoPlayer
 @param seekTime seek的时间
 */
- (void)BeeVideoPlayerView:(BeeVideoPlayerView *)videoPlayer didSeekToTime:(NSTimeInterval)seekTime;

/**
 播放状态变化的回调
 
 @param videoPlayer
 @param newState @see BEEVideoPlayerState
 */
- (void)BeeVideoPlayerView:(BeeVideoPlayerView *)videoPlayer willChangeState:(BEEVideoPlayerState)newState;

/**
 发生错误时的回调
 
 @param videoPlayer
 @param error error信息
 */
- (void)BeeVideoPlayerView:(BeeVideoPlayerView *)videoPlayer failed:(NSError *)error;
/**
 发生错误时的回调
 
 @param videoPlayer
 @param error error信息
 */
- (void)BeeVideoPlayerView:(BeeVideoPlayerView *)videoPlayer failed:(NSError *)error andRetry:(BOOL)retry;

/**
 点击View回调
 
 @param videoPlayer
 @param tag 按钮标签 @see BeeVideoPlayerToolBarBtnTag
 */
- (void)BeeVideoPlayerView:(BeeVideoPlayerView *)videoPlayer ClickedBtn:(BeeVideoPlayerViewTag)tag;



/**
 显示View
 @param videoPlayer
 @param isShow 是否需要显示
 @param tag 按钮标签 @see BeeVideoPlayerViewTag
 */
- (void)BeeVideoPlayerView:(BeeVideoPlayerView *)videoPlayer showView:(BOOL)isShow byViewTag:(BeeVideoPlayerViewTag)tag;

/**
 control view隐藏/显示状态回调
 
 @param videoPlayer
 @param isVisible control是否可见
 */
- (void)BeeVideoPlayerView:(BeeVideoPlayerView *)videoPlayer controlVisible:(BOOL)isVisible;

/**
 视频截图回调
 
 @param videoPlayer
 @param snapshot 截图结果，UIImage对象
 */
- (void)BeeVideoPlayerView:(BeeVideoPlayerView *)videoPlayer snapshotImage:(UIImage *)snapshot;



/**
 开始下载视频

 @param videoPlayer
 @param url 视频URL
 @param business 业务ID
 */
- (void)BeeVideoPlayerView:(BeeVideoPlayerView *)videoPlayer startDownLoadVideo:(NSString *)url withBusiness:(NSString *)business;


/**
 下载视频进度

 @param videoPlayer
 @param url 下载视频URL
 @param business 业务ID
 @param progress 进度 0~100%
 */
- (void)BeeVideoPlayerView:(BeeVideoPlayerView *)videoPlayer downLoadVideo:(NSString *)url withBusiness:(NSString *)business    :(double)progress;


/**
 下载视频URL错误

 @param videoPlayer
 @param url 下载的视频URL
 @param business 业务ID
 */
- (void)BeeVideoPlayerView:(BeeVideoPlayerView *)videoPlayer completeDownLoadVideo:(NSString *)url withBusiness:(NSString *)business error:(NSError *)error;



/**
 插件 行为事件

 @param videoPlayer
 @param action 
 */
- (void)BeeVideoPlayerView:(BeeVideoPlayerView *)videoPlayer controlViewTouchBeginWithAction:(id)action;



/**
 视频正在切换清晰度

 @param videoPlayer
 @param isSwitchEnd 是否切换中/ 切换完成
 @param error 切换错误
 */
- (void)BeeVideoPlayerView:(BeeVideoPlayerView *)videoPlayer qualitySwitching:(BOOL)isSwitchEnd withError:(NSError *)error;



/**
 属性修改通知

 @param videoPlayer
 @param propertyName 
 */
- (void)BeeVideoPlayerView:(BeeVideoPlayerView *)videoPlayer changeProperty:(NSString *)propertyName;



/**
 父页面布局发生改变

 @param videoPlayer 
 */
- (void)BeevideoPlayerViewLayoutChange:(BeeVideoPlayerView *)videoPlayer;


/**
 耳机设备连接状态变化

 @param videoPlayer
 */
- (void)BeevideoPlayerView:(BeeVideoPlayerView *)videoPlayer audioRouteChange:(BeeVideoPlayerAudioRouteChangeType)routeChange;

@end

#endif /* IBeeVideoPlayerPlugin_h */


@protocol BeeVideoHandlerDelegate <NSObject>

- (void)controlViewBtnClicked:(BeeVideoPlayerViewTag)tag;

@end
