//
//  BeeVideoUrlsUtils.h
//  BeeMediaPlayer
//
//  Created by zidan on 2019/7/30.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface BeeVideoUrlsUtils : NSObject

/**
 弥补BeeVideoManager的获取本地文件

 @param localId
 @param bizType
 @return
 */
+ (NSString *)getRealPathFromLocalId:(NSString *)localId withBizType:(NSString *)bizType;

/**
 从Json结构的string中解析 获得URL数组

 @param UrlString
 @return
 */
+ (NSArray *)getUrlsForUrlString:(NSString *)UrlString;


/**
 获取默认的PosterURl, 默认去SD 格式的， 如果URL中没有， 则获取数组中的第一个

 @param urls
 @return 返回默认的URL
 */
+ (NSString *)getDefaultPosterURL:(NSArray *)urls;
@end

NS_ASSUME_NONNULL_END
