//
//  BeeVideoTouchesPlugin.h
//  BeeMediaPlayer
//
//  Created by zidan on 2019/5/5.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "IBeeVideoPlayerPlugin.h"

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, BeeControlMoveAction) {
    BeeControlMoveAction_Unknown,
    BeeControlMoveAction_Brightness,
    BeeControlMoveAction_Volume,
    BeeControlMoveAction_Seek
};

@protocol BeeVideoTouchesPluginDelegate <NSObject>

//返回YES，可以执行相应的手势操作；返回NO，不执行
- (BOOL)shouldHandleTouchWithAction:(BeeControlMoveAction)action;
- (void)controlViewTouchBeginWithAction:(BeeControlMoveAction)action;
- (void)controlViewTouchEndWithAction:(BeeControlMoveAction)action;

- (void)seekToTime:(NSTimeInterval)time;

- (void)tapAction:(UITapGestureRecognizer *)gesture;

@end

@interface BeeVideoTouchesPlugin : UIView<BeeVideoPlayerPluginDelegate>

@property (nonatomic, weak) id<BeeVideoTouchesPluginDelegate> delegate;

@end

NS_ASSUME_NONNULL_END
