//
//  BeeVideoPlayerView.h
//  BeeMediaPlayer
//
//  Created by manyi.zsf on 2017/3/29.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "IBeeVideoPlayer.h"
#import "BeePluginManager.h"
#import "IBeeVideoPlayerPlugin.h"

typedef NS_ENUM(NSInteger, BeeVideoBarShowMode) {
    BeeVideoBarShowMode_InitShow,       //初始显示，自动隐藏，点击后可显示/隐藏
    BeeVideoBarShowMode_AlwaysHide,     //一直隐藏
    BeeVideoBarShowMode_InitHide,       //初始隐藏，状态变化或点击后可显示/隐藏
    BeeVideoBarShowMode_AlwaysShow,     //一直显示，不会隐藏
    BeeVideoBarShowMode_showWhenTap,    //一直隐藏，只在点击的时候才会显示
};

typedef NS_ENUM(NSInteger, BeeVideoPlayerControlMode) {
    BeeVideoPlayerControlMode_None = 0,
    BeeVideoPlayerControlMode_CenterPlay = 1 << 0,       //居中play按钮模式
    BeeVideoPlayerControlMode_ToolBar = 1 << 1,          //工具条模式
};

typedef NS_ENUM(NSInteger, BeeVideoPlayMode) {
    BeeVideoPlayMode_PlayWhenDownloading,       //边下边播，default
    BeeVideoPlayMode_PlayAfterDownloaded,       //下载完再播放
};

typedef NS_ENUM(NSInteger, BeePlayerCoreMode) {
    BeePlayerCoreMode_Unknown,      //未知
    BeePlayerCoreMode_AliPay,       //多媒体自己的播放器内核
    BeePlayerCoreMode_YouKu,         //优酷播放器内核
    BeePlayerCoreMode_RTC,           //RTC 播放View
    BeePlayerCoreMode_MF,            // Mediaflow 播放器
};

@class BeeVideoPlayerView;
@protocol BeeVideoPlayerViewDelegate <BeeVideoPlayerPluginDelegate>

@optional
/**
 AutoPlay的时候，播放前给业务方一个干涉的机会
 
 @param videoPlayer
 @return YES - 正常开始播放；NO - 不播放
 */
- (BOOL)BeeVideoCanAutoPlay:(BeeVideoPlayerView *)videoPlayer;

/**
 playMode == BeeVideoPlayMode_PlayAfterDownloaded时，下载前给业务方一个干涉的机会
 
 @param videoPlayer
 @return YES - 开始下载；NO - 不下载
 */
- (BOOL)BeeVideoCanDownload:(BeeVideoPlayerView *)videoPlayer;

/**
 发生错误时的回调
 
 @param videoPlayer
 @param error error信息
 @return YES - 业务层已处理，组件不再处理错误信息；NO - 按组件默认方式处理错误信息
 */
- (BOOL)BeeVideoPlayerView:(BeeVideoPlayerView *)videoPlayer failedWithError:(NSError *)error;

/**
 view点击回调
 
 @param videoPlayer
 @param ptInView view坐标系的点击位置
 @param ptInVideo video坐标系的点击位置
 @return YES - 业务层已处理，不需要组件再处理；NO - 组件默认处理，如显示/隐藏toolbar等
 */
- (BOOL)BeeVideoPlayerView:(BeeVideoPlayerView *)videoPlayer handleClickInView:(CGPoint)ptInView andInVideo:(CGPoint)ptInVideo;


/**
 视频的扩展信息回调， 目前扩展信息用于 优酷的UPS信息返回。

 @param videoPlayer
 @param info 扩展信息
 */
- (void)BeeVideoPlayerView:(BeeVideoPlayerView *)videoPlayer extraInfo:(NSDictionary *)info;
@end

@interface BeeVideoPlayerView : UIView <BeeVideoHandlerDelegate>

- (instancetype)initWithFrame:(CGRect)frame andCoreMode:(BeePlayerCoreMode)coreMode;
- (void)deInit;

//扩展初始化方法，增加参数控制是否加载默认plugins，CoreMode固定初始化为BeePlayerCoreMode_YouKu
- (instancetype)initWithFrame:(CGRect)frame andNeedDefaultPlugins:(BOOL)needDefaultPlugins;
@property (nonatomic, assign, readonly) BOOL needDefaultPlugins;

//回调代理，@see BeeVideoPlayerViewDelegate
@property (nonatomic, weak) id<BeeVideoPlayerViewDelegate> delegate;

//当前播放状态
@property (nonatomic, assign, readonly) BEEVideoPlayerState state;

/**
 当前的播放器内核
 */
@property (nonatomic, strong, readonly) id<IBeeVideoPlayer> player;
//视频对应的url
@property (nonatomic, copy, readonly) NSString *videoUrl;

@property (nonatomic, strong) NSString *referer;
//
@property (nonatomic, copy, readonly) NSString *business;
//播放器当前的缩略图view
@property (nonatomic, strong, readonly) UIImageView *thumbnailView;

//@see BeePlayerCoreMode, 切换播放内核；default is BeePlayerCoreMode_AliPay
@property (nonatomic, assign) BeePlayerCoreMode coreMode;
//@see BeeVideoPlayMode, 需要在setVideoUrl:withBusiness:方法前设置
@property (nonatomic, assign) BeeVideoPlayMode playMode;
//@see BeeVideoPlayerControlMode, default is BeeVideoPlayerControlMode_None
@property (nonatomic, assign) BeeVideoPlayerControlMode ctrlMode;
//@see BeeVideoBarShowMode default is BeeVideoBarShowMode_InitShow
@property (nonatomic, assign) BeeVideoBarShowMode topBarShowMode;
//@see BeeVideoBarShowMode default is BeeVideoBarShowMode_InitShow
@property (nonatomic, assign) BeeVideoBarShowMode toolBarShowMode;
//bottomBar包含了toolbar、静音按钮等
@property (nonatomic, assign) BeeVideoBarShowMode bottomBarShowMode;
//中部按钮的显示或者隐藏状态
@property (nonatomic, assign) BeeVideoBarShowMode centerShowMode;
//自动播放，default is YES
@property (nonatomic, assign) BOOL isAutoPlay;
//循环播放，default is YES
@property (nonatomic, assign) BOOL isAutoReplay;
//静音模式，default is YES
@property (nonatomic, assign) BOOL isMuted;
//音频焦点抢占，默认跟随isMuted属性，非静音的时候抢占，静音的时候不抢占
@property (nonatomic, assign) BOOL enableAudioExclusive;
/// 是否开启Cache，  Default is YES  ， 开启循环播放， enableCache 为True；
@property (nonatomic, assign) BOOL enableCache;
//视频填充模式，default is YES, 填满全屏
//这个命名容易跟全屏属性isFullScreen搞混，需要优化
@property (nonatomic, assign) BOOL isFillScreen;
//@see BeeVideoType, default is BeeVideoType_ShortVideo
@property (nonatomic, assign) BeeVideoType videoType;
//在缩略图下载下来之前的占位图像
@property (nonatomic, strong) UIImage *placeholder;
//当前的屏幕旋转方向
@property (nonatomic, assign) UIInterfaceOrientation currentInterfaceOrientation;
//起播初始时间
@property (nonatomic, assign) NSTimeInterval initialTime;
//视频总时长
@property (nonatomic, assign) NSTimeInterval duration;
//当前播放时长
@property (nonatomic, assign, readonly) NSTimeInterval currentPosition;
//视频渲染特效
@property (nonatomic, assign) BeeVideoPlayerRenderEffect renderEffect;
//重复播放时间区间
@property (nonatomic, assign) NSTimeInterval replayStartTime;
@property (nonatomic, assign) NSTimeInterval replayEndTime;
//页面不动，旋转视频
@property (nonatomic, assign) BOOL rotateVideo;
//播放完是否回到首帧, default is YES
@property (nonatomic, assign) BOOL firstFrameWhenFinished;
//是否全屏
@property (nonatomic, assign) BOOL isFullScreen;
//中间播放按钮是否显示暂停状态，默认NO
@property (nonatomic, assign) BOOL isShowCenterPlayWithPauseState;
//扩展信息，需要在setVideoUrl之前设置
@property (nonatomic, copy) NSDictionary *extraInfo;
//批量UPS接口返回的mediaConfig参数，直接返回cdnurl，不用再请求UPS接口
//需要在setVideoUrl之前设置
@property (nonatomic, copy) NSDictionary *mediaConfig;
//从mediaConfig中取到的真实播放url
@property (nonatomic, copy, readonly) NSString *mediaConfigUrl;
//从mediaConfig中取到的当前播放url的渠道：cdnUrl, vid, afts
@property (nonatomic, copy, readonly) NSString *mediaConfigChannel;
//倍速播放
@property (nonatomic, assign) CGFloat playbackRate;

/// 展示的倍速
@property (nonatomic, copy)  NSString *displayRate;
//视频分辨率
@property (nonatomic, assign, readonly) CGSize videoSize;
//视频帧率fps
@property (nonatomic, assign, readonly) NSInteger videoFPS;
//视频存储大小，单位B
@property (nonatomic, assign) long long videoStorageSize;
//强制中断播放，调用play方法也不会播放
@property (nonatomic, assign) BOOL isInterrupted;
//移动网络下是否显示提醒，默认YES
@property (nonatomic, assign) BOOL showTipWhenNoWifi;
//是否本地视频
@property (nonatomic, assign) BOOL isLocal;

/// 优酷vid默认清晰度（1-省流；2-标清；3-高清；4-超清；5-蓝光）
/// 会根据网络情况配置不同的默认清晰度，移动网络：3；WiFi：4
@property (nonatomic, assign, readonly) NSInteger defaultDefinition;
/// 清晰度列表
@property (nonatomic, copy, readonly) NSArray *allQualityList;
/// 清晰度 (FD / HD / SD / ...)
@property (nonatomic, copy, readonly) NSString *quality;
/// 清晰度描述 (1080P / 720P / 540P / ...)
@property (nonatomic, copy, readonly) NSString *qualityDesc;

@property (nonatomic, assign) CGRect displayAreaFrame;
/**
 是否是isYoukuVid
 */
@property (nonatomic, assign) BOOL isYoukuVid;
//全屏时是否开启控制进度的手势，默认是YES
@property (nonatomic, assign) BOOL enableProgressGesture;
//埋点信息
@property (nonatomic, copy, readonly) NSDictionary *logInfo;
// 是否错误状态
@property (nonatomic, assign, readonly) BOOL isError;

@property (nonatomic, assign) BOOL isShowRate;

// 是否本地存在缓存
@property (nonatomic, assign, readonly) BOOL isPlayFromCache;

//内部参数暴露，只读属性
@property (nonatomic, strong, readonly) BeePluginManager *pluginManager;  //plugin管理器
//是否浮窗模式
@property (nonatomic, assign) BOOL isFloatViewMode;
//通过BeeVideoCreateFactory类中prepare方法创建的实例会设置为YES
//如果为YES，则不会自动播放，业务主动调用play方法后会重置为NO
@property (nonatomic, assign) BOOL isPreparing;

@property (nonatomic, copy) NSString *resourceId;


// 告知底层是否启用了系统的画中画功能
@property (nonatomic, assign) BOOL enableSystemPIP;

#pragma mark - 暴露方法
//播放
- (void)play;
//暂停
- (void)pause;
//停止
- (void)stop;
//是否正在播放
- (BOOL)isPlaying;
//seek
- (void)seekToTime:(NSTimeInterval)time;

//重置播放器
- (void)resetPlayer;

/**
 设置视频源

 @param url
 @param business
 */
- (void)setVideoUrl:(NSString *)url withBusiness:(NSString *)business;

- (void)showBtn:(BOOL)isShow byTag:(BeeVideoPlayerViewTag)tag;

- (void)setInterruptValueOnly:(BOOL)interrupted;

//插件管理
- (void)addPluginItems:(NSArray *)items;

- (void)removePluginItems:(NSArray *)items;

- (void)displayArea:(CGRect)frame;
/**
 点击制定tag的button

 @param tag @see BeeVideoPlayerBtnTag
 */
- (void)handleClickedBtnTag:(BeeVideoPlayerViewTag)tag;

/**
 视频截图，结果在delegate回调中返回
 
 @param size 截图结果的大小, {0, 0}取视频分辨率
 */
- (void)captureVideoWithSize:(CGSize)size;

/**
 外部原因触发错误
 
 @param error error.code:错误码；
              error.userInfo: @{@"errorInfo":@"错误提示信息"}
 */
- (void)fireError:(NSError *)error withRetry:(BOOL)canRetry;

/**
 设置直播缓存的下限

 @param minCache
 */
- (void)setLiveMinCache:(float)minCache;

/**
 设置直播缓存的上限

 @param maxCache 
 */
- (void)setLiveMaxCache:(float)maxCache;

- (void)updateVideoUrl:(NSString *)url;

- (void)changeQuality:(NSString *)quality;

- (NSTimeInterval)getCurrentTime;

// 是否开启背景模糊特效，需要在isFillScreen为NO的情况下才设置有效
- (void)enableBackgroundBlurEffect:(BOOL)enable;

/**
 设置UEP埋点信息
 也可以在extraInfo设置“reportString”
 
 @param bizId 业务Id，唯一。双端统一，native/H5接入业务自定义，小程序默认为appid
 @param spm spm点位
 @param scm scm数据
 @param extInfo1 扩展参数
 @param extInfo2 扩展参数，目前不使用
 */
- (void)setUEPReportInfo:(NSString *)bizId
                     spm:(NSString *)spm
                     scm:(NSString *)scm
                extInfo1:(NSDictionary *)extInfo1
                extInfo2:(NSDictionary *)extInfo2;

// 获取已设置的UEP埋点信息
- (NSDictionary *)uepReportInfo;

@end
