//
//  BeeVideoCountdownPlugin.h
//  BeeMediaPlayer
//
//  Created by zidan on 2021/9/30.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

#import "IBeeVideoPlayerPlugin.h"

NS_ASSUME_NONNULL_BEGIN


typedef void(^BeeCountdownSizeBlock)(CGSize contextSize);

@interface BeeVideoCountdownPlugin : UIView <BeeVideoPlayerPluginDelegate>
/// 默认值为12.f
@property (nonatomic, assign) float layoutTop;
/// 默认值为12.f
@property (nonatomic, assign) float layoutLeft;

/// 默认为MAXFLOAT 非MAXFLOAT， 则优先使用bottom布局 忽略top
@property (nonatomic, assign) float layoutBottom;
/// 默认为MAXFLOAT 非MAXFLOAT， 则优先使用right布局  忽略left
@property (nonatomic, assign) float layoutRight;

/// 字体大小, 默认12.f weight : Medium 。
@property (nonatomic, assign) float fontSize;

/// 字体颜色， 默认12
@property (nonatomic, strong) UIColor *fontColor;

/// 边距
@property (nonatomic, assign) UIEdgeInsets margin;


@property (nonatomic, assign) CGSize contextSize;

@property (nonatomic, assign) BOOL customFrame;

@property (nonatomic, copy) BeeCountdownSizeBlock sizeBlock;

@end

NS_ASSUME_NONNULL_END
