//
//  BeePreloadTaskManager.h
//  BeeMediaPlayer
//
//  Created by manyi.zsf on 2021/3/7.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef void (^BeePreloadTaskCallback)(BOOL isSuccess);

@class BeePreloadTaskObj;
@protocol BeePreloadTaskDelegate <NSObject>

- (void)BeePreloadTask:(BeePreloadTaskObj *)obj complete:(BOOL)isSuccess;

@end

@interface BeePreloadTaskObj : NSObject

@property(nonatomic, copy) NSString *src;
@property(nonatomic, copy) NSDictionary *extraInfo;
@property(nonatomic, copy) NSDictionary *mediaConfig; // 批量UPS接口返回的数据结构
@property(nonatomic, copy) BeePreloadTaskCallback callback __attribute__((deprecated));
@property(nonatomic, weak) id<BeePreloadTaskDelegate> delegate;

@end

@interface BeePreloadTaskManager : NSObject

+ (instancetype)sharedManager;
- (void)addTask:(BeePreloadTaskObj *)obj;

@end
