//
//  BeePluginManager.h
//  BeeMediaPlayer
//
//  Created by manyi.zsf on 2018/10/19.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, BeePluginLevel) {
    BeePluginLevel_Defalut = 1 << 0,
    BeePluginLevel_Low = 1 << 1,
    BeePluginLevel_Middle = 1 << 2,
    BeePluginLevel_High = 1 << 3,
    BeePluginLevel_Undeletable = 1 << 4, // 不可删除
};

@protocol BeeBasePluginItem <NSObject>


- (void)pluginItemDidInstall:(id)mainView;
- (void)pluginItemDidUninstall:(id)mainView;


///  是否可编辑， 默认可编辑
- (BeePluginLevel)pluginLevel;

@end

@interface BeePluginManager : NSObject

@property (nonatomic, weak) UIView *mainView;
//weak引用
- (void)addDelegate:(id)delegate;
//strong引用
- (void)addItems:(NSArray *)items;
- (void)removeItems:(NSArray *)items;
- (void)removeAllPlugin;
- (void)replaceItemOfClass:(Class)itemClass withNewItem:(id)item;
- (void)invokeSelector:(SEL)selector withArguments:(NSArray *)arguments;

@end

NS_ASSUME_NONNULL_END
