//
//  BEELocationPicker+paramExtension.h
//  BeeLocationPicker
//
//  Created by 莜阳 on 17/2/23.
//  Copyright © 2017年 Alipay. All rights reserved.
//


#import "BEELocationPicker.h"
#import "BEELocationPickerCell.h"
#import "BEELocationLoadingView.h"
#import "BEESearchLocationHelper.h"
#import "BEELocationSwitchTabView.h"
#import "BEELocationSearchHistoryView.h"

//
typedef NS_ENUM(NSInteger, BeeMapViewSizeType)
{
    BeeMapViewSizeTypeSmaller,
    BeeMapViewSizeTypeDefault,
};


@interface BEELocationPicker() <UISearchBarDelegate, UITextFieldDelegate, UISearchDisplayDelegate, UITableViewDelegate, UITableViewDataSource>
{
    BEELocationSwitchTabType _currentTabType;
    NSString *_hightLightKey;
    CGFloat _lastContentOffset;
    BOOL _scrollToChangeMapView; // 是否需要上下滚动改变地图大小
    BOOL _hasRegeoLocation; // 带地图页面是否需要逆地理当前位置
    BeeMapViewSizeType _mapviewSizeType;
}

@property (nonatomic, assign) CLLocationAccuracy accuracy;
@property (nonatomic, assign) NSInteger curReqPageIndex;
@property (nonatomic, strong) NSMutableDictionary *resultHasMoreDic;
@property (nonatomic, strong) AMapPOI *selectedPOI;
@property (nonatomic, strong) NSString *rid; // 埋点数据
@property (nonatomic, strong) NSMutableArray *searchResultArray;
@property (nonatomic, strong) NSMutableArray *resultForOfficeBuilding;
@property (nonatomic, strong) NSMutableArray *resultForvillage;
@property (nonatomic, strong) NSMutableArray *resultForSchool;
@property (nonatomic, assign) CLLocationCoordinate2D currentLocation;
@property (nonatomic, strong) NSMutableArray *resultArray;
@property (nonatomic, strong) BEELocationPickerParams *params;
@property (nonatomic, strong) LBSAddressInfo *currentAddressInfo;
@property (nonatomic, strong) UISearchBar *searchBar;
@property (nonatomic, strong) AUTableView *tableView;
@property (nonatomic, strong) BEELocationSearchHistoryView *searchHistoryView;
@property (nonatomic, strong) UISearchDisplayController *searchViewController;
@property (nonatomic, strong) BEELocationLoadingView *searchPageFooterView;
@property (nonatomic, strong) BEELocationLoadingView *poiPageFooterView;
@property (nonatomic, strong) BEELocationSwitchTabView *switchTabView;
@property (nonatomic, strong) UILabel *searchResultTipLabel;
@property (nonatomic, strong) UIView *searchBarBackgroundView;
@property (nonatomic, strong) UIView *navigationBarBGView;
@property (nonatomic, strong) APMapSendLocationView *mapView;
@property (nonatomic, assign) BOOL needRecommondList;   // 10.1.60 单搜索组件,是否在进入是需要展示推荐地址列表
@end
