//
//  BeeCityPickerLogger.h
//  BeeCityPicker
//
//  Created by 百喻 on 2019/11/7.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger,BeeLogLevel) {
    BeeLogLevelHigh   = 1,  //级别最高
    BeeLogLevelNormal = 2,  //默认级别
    BeeLogLevelLow    = 3   //级别最低
};

const static NSString *kLogError                    = @"error";
const static NSString *kLogErrorMsg                 = @"errorMessage";

// dataSource
const static NSInteger kSource_merge    = 0;
const static NSInteger kSource_rpcCache = 1;
const static NSInteger kSource_rpc      = 2;

// dataType
static NSString *const kTypeOverseaCity = @"chooseMainCity";
static NSString *const kTypeMainCity = @"chooseMainChinaCity";
static NSString *const kTypeChooseCity = @"chooseCity";
static NSString *const kTypeRegionPicker = @"regionPicker";
static NSString *const kTypeGetProvince = @"getProvince";
static NSString *const KTypeCustomSelectDistrict = @"customSelectDistrict";

// cardType
const static NSInteger kCardType_cdp    = 1;
const static NSInteger kCardType_card   = 2;
const static NSInteger kCardType_all    = 3;

// mapCode
const static NSInteger kCode_success  = 1;
const static NSInteger kCode_fail     = 2;

@interface BeeCityPickerLogger : NSObject
+ (void)logHistoryCityDelete:(NSString *)cityName appId:(NSString *)appId;
+ (void)logJsApiCall:(NSString *)jsApi appId:(NSString *)appId;
+ (void)logJsApiExecutionTime:(NSTimeInterval)start end:(NSTimeInterval)end jsApi:(NSString *)jsApi source:(NSString *)source logLevel:(BeeLogLevel)logLevel appId:(NSString *)appId;
+ (void)logJsApiError:(NSString *)jsApi errorInfo:(NSDictionary *_Nullable)errorInfo appId:(NSString *)appId;
// cacheMode: 1缓存 2rpc
+ (void)logOverseaCityInfo:(NSInteger)cacheMode version:(NSString *)version appId:(NSString *)appId;
+ (void)logMainlandCityInfo:(NSInteger)code version:(NSString *)version appId:(NSString *)appId;
+ (void)logCityData:(NSString *)type code:(NSInteger)code version:(NSString *)version appId:(NSString *)appId;
+ (void)logCityData:(NSString *)type code:(NSInteger)code version:(NSString *)version ext:(NSString *)ext appId:(NSString *)appId;
+ (void)logCityCount:(NSInteger)count isOversea:(BOOL)isOversea appId:(NSString *)appId;
// type: kCardType
+ (void)logCityCard:(NSInteger)type appId:(NSString *)appId;
+ (void)logCardErr:(NSInteger)errorCode source:(NSString *)source cityCode:(NSString *)cityCode appId:(NSString *)appId;

+ (void)logCityEnDiff:(NSString *)key matchValue:(NSString *)matchValue appId:(NSString *)appId;
+ (void)logLoadDistrictPRC:(NSString *)type version:(NSString *)version succeed:(BOOL)succeed errorCode:(NSString *)errorCode appId:(NSString *)appId;

+ (void)logEvent:(NSString *)event type:(NSString *)type source:(NSString *)source code:(NSInteger)code;
+ (void)logEvent:(NSString *)event type:(NSString *)type source:(NSString *)source code:(NSInteger)code ext:(NSString *)ext;
@end

NS_ASSUME_NONNULL_END
