//
//  BEECityRegionData.h
//  BeeCityPicker
//
//  Created by Yanzhi on 16/4/8.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
//#import "BEECustomItem.h"

typedef void(^BeeCityRegionDataAdVersionBlock) (NSArray *cityList);

@class BEECity;

@protocol BEECityRegionDataDelegate <NSObject>

// 二进制完成生成完毕，写入到以下文件中
- (void)didFinishLoadBinCache:(NSDictionary *)binDict toFile:(NSString *)filePath;

@end

@interface BEECityRegionData : NSObject
@property (nonatomic, assign) BOOL isENMode;
@property (nonatomic, assign) BOOL isInLand;
@property (nonatomic, weak) id<BEECityRegionDataDelegate> delegate;
@property (nonatomic, strong) NSMutableDictionary *cityDict;
@property (nonatomic, strong) NSMutableDictionary *cityCodeDict;
@property (nonatomic, strong) NSArray<NSString *> *cityIdxArray;
@property (nonatomic, strong) NSString  *customSectionText;
@property (nonatomic, strong) NSString  *customSectionIndex;

// 用于埋点
@property (nonatomic, copy) NSString *cityDataVersion;
@property (nonatomic, assign) NSInteger cityDataSource;

// 支持对内置数据处理
@property (nonatomic, strong) NSArray<BEECity *> *addCityArray;
@property (nonatomic, strong) NSArray<NSString *> *removeCityArray;
@property (nonatomic, strong) NSArray<NSString *> *hotCityArray;

/**
 * @desc 构建全部城市数据
 */
- (BOOL)buildAllCityList:(NSArray<NSString *> *)busiCities canMockData:(BOOL)canMockData;

// 构建城市分组数据
- (NSMutableDictionary *)buildAllCityDict:(NSArray<BEECity *> *)busiCityList;

/**
 * @desc 构建热门城市数据
 */
- (void)buildHotCityList:(NSArray<NSString *> *)busiCities canMockData:(BOOL)canMockData;

/**
 * @desc 构建历史城市数据
 */
- (void)buildHistoryCityList:(NSArray<NSString *> *)busiCities;

/**
 * @desc 构建定位城市数据
 */
- (void)buildLBSCityList:(NSArray<BEECity *> *)beeCities;

/**
 * @desc 构建自定义数据列表，位于历史数据后面
 */
//- (void)buildCustomItemList:(NSArray<BEECustomItem *> *)customItems;

/**
 * @desc 建立城市数据的索引
 */
- (void)buildCityIndex;

/**
* @desc 建立城市数据的索引
* isAllCity: YES:城市列表 NO:热门城市列表
* needFilter: 是否需要过滤港澳台
*/
- (void)loadCacheWithBinFile:(NSString *)binFile textFile:(NSString *)textFile isAllCity:(BOOL)isAllCity needFilter:(BOOL)need __attribute__((deprecated("Use loadCachedAllCity:needFilter: instead.")));
- (void)loadCachedAllCity:(BOOL)isAllCity needFilter:(BOOL)need;

- (void)loadCachedAllCity:(BOOL)isAllCity needFilter:(BOOL)need appId:(NSString *)appId adVersion:(NSString *)adVersion completion:(BeeCityRegionDataAdVersionBlock)completion;

@end
