//
//  BEECity.h
//  ALPDiscoveryWidget
//
//  Created by yukai44444 on 14-3-5.
//  Copyright (c) 2014年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, BEECitySource) {
    BEECitySourceUnDefine,      // 默认
    BEECitySourceSearch,        // 搜索结果
    BEECitySourceLocation,      // 定位块
    BEECitySourceHistory,       // 历史块
    BEECitySourceHotList,       // 热门块
    BEECitySourceNormalList     // 普通城市列表
};

@interface BEECity : NSObject

/**
 * 国家名， 暂时定位模块用
 */
@property(nonatomic, copy) NSString *country;

/**
 * 国家码， 暂时定位模块用
 */
@property(nonatomic, copy) NSString *countryCode;

/**
 * 省名
 */

@property(nonatomic, strong) NSString *province;

/**
 * 省份码， 暂时定位模块用
 */

@property(nonatomic, copy) NSString *provinceCode;
/**
 * 城市名
 */
@property(nonatomic, strong) NSString *city;

/**
 * 城市名称全称
 */
@property(nonatomic, strong) NSString *fullCityName;

/**
 * 城市码， 暂时定位模块用
 */
@property(nonatomic, copy) NSString *cityAdcode;

/**
 * 城市名称全拼
 */

@property(nonatomic, strong) NSString *pinyin;

/**
 * 城市英文名称
 */

@property(nonatomic, copy) NSString *enName;

/**
 * 当前地区码
 */

@property(nonatomic, strong) NSString *adcode;

/**
 * 境内或境外标识
 */
@property (nonatomic, assign) BOOL oversea;

/**
 *  扩展参数
 */
@property (nonatomic, strong) NSString *externParam;

/**
 *  跳转链接
 */
@property (nonatomic, strong) NSString *schemaUrl;

/**
 *  地理位置信息
 */
@property (nonatomic, strong) CLLocation *location;

/**
*  所在的区块
*/
@property (nonatomic, assign) BEECitySource source;

// 只用于搜索界面使用，不做城市数据一部分
@property (nonatomic, copy) NSString *primarySearchKey;
@property (nonatomic, copy) NSString *secondarySearchKey;

@end
