//
//  BeeAudioUtils.h
//  BEEAudioUtil
//
//  Created by 莜阳 on 17/1/17.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <BEEAudioUtil/BeeAudioView.h>
#import <BEEAudioUtil/BeeAudioItemView.h>
#import <BEEAudioUtil/BeeAudioButtonView.h>

NS_INLINE NSInteger BEEAudioJSErrCode(NSInteger errCode)
{
    if (errCode == -11828) {
        //格式错误
        return 10004;
    }else if(errCode == -11829||errCode == -1100){
        //文件错误
        return 10003;
    }else if(errCode >= -1014&&errCode <=- 1000){
        //网络错误
        return 10002;
    }else if(errCode == -11839||errCode == -11819){
        //系统错误
        return 10001;
    }else{
        //未知错误
        return -1;
    }
}

NS_INLINE void BEEAudioLogger(NSString *appid, NSString *url,NSString *status, NSError *error, NSString * productType)
{
#ifndef BeeHive_For_mPaaS
    NSDictionary *dic = @{@"monitor_type":@"audioPlay",
                          @"product_type":productType ?: @"",
                          @"business_id":@"H5AudioPlugin",
                          @"source_appid":appid ?: @"",
                          @"video_vid":url ?: @"",
                          @"status": status ?: @"",
                          @"status_code":@(error.code),
                          @"src_status_code":@(BEEAudioJSErrCode(error.code)),
                          @"player_core":@"alipay",
                          @"play_way":@"net",
                          };
    AntEvent *event = [[AntEvent alloc] init];
    event.bizType = @"middle";
    event.eventId = @"10042";
    event.logLevel = AntLogLevelNormal;
    event.extParam4 = dic;
    [ATEventLoggerGet() log:event];
#endif
}

NS_INLINE void BEEAudioUpdateStoreInfo(NSString *url, NSTimeInterval position, NSTimeInterval duration)
{
    if (url.length == 0) {
        return;
    }
    
    NSNumber *positionNumber = [NSNumber numberWithDouble:position];
    NSNumber *durationNumber = [NSNumber numberWithDouble:duration];
    NSDictionary *dic = @{@"url":url, @"position":positionNumber, @"duration": durationNumber};

    NSArray *storeArray = [APUserPreferences objectForKey:@"BEEAudioStoreArray" business:@"BEEAudio"] ?: @[];
    NSMutableArray *mutableStoreArray = [storeArray mutableCopy];

    __block BOOL urlExist = NO;
    __block NSUInteger idxExist = 0;
    [storeArray enumerateObjectsUsingBlock:^(id  _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        NSDictionary *storeDic = (NSDictionary *)obj;
        if ([storeDic[@"url"] isEqualToString:url]) {
            urlExist = YES;
            idxExist = idx;
            *stop = YES;
        }
    }];
    
    if (urlExist) {
        [mutableStoreArray replaceObjectAtIndex:idxExist withObject:dic];
    } else {
        if (storeArray.count >= 30) {
            [mutableStoreArray removeObjectAtIndex:0];
        }
        [mutableStoreArray addObject:dic];
    }
    
    [APUserPreferences setObject:[mutableStoreArray copy] forKey:@"BEEAudioStoreArray" business:@"BEEAudio"];
}

NS_INLINE NSDictionary* BEEAudioGetStoreInfo(NSString *url)
{
    NSArray *storeArray = [APUserPreferences objectForKey:@"BEEAudioStoreArray" business:@"BEEAudio"];
    
    __block BOOL urlExist = NO;
    __block NSUInteger idxExist = 0;
    [storeArray enumerateObjectsUsingBlock:^(id  _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        NSDictionary *storeDic = (NSDictionary *)obj;
        if ([storeDic[@"url"] isEqualToString:url]) {
            urlExist = YES;
            idxExist = idx;
            *stop = YES;
        }
    }];
    
    if (urlExist) {
        NSDictionary *dic = [storeArray objectAtIndex:idxExist];
        if (dic) {
            return dic;
        }
    }
    
    return @{};
}
