//
//  BeeAudioItemInfo.h
//  BeeViews
//
//  Created by 莜阳 on 17/1/10.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <APMultimedia/APAudioPlayer.h>

@interface BeeAudioItemInfo : NSObject

@property (nonatomic, strong) NSString *songIdentifier;         // 歌曲标识，songId 或者 URL
@property (nonatomic, strong) NSString *songName;               // 歌曲名称
@property (nonatomic, strong) NSString *singerName;             // 艺人名字
@property (nonatomic, strong) NSString *songDescText;           // 歌曲描述
@property (nonatomic, assign) NSTimeInterval totalDuration;     // 歌曲总时长
@property (nonatomic, assign) NSTimeInterval playingDuration;   // 歌曲当前播放时长
@property (nonatomic, strong) NSString *songlogoURL;            // 歌曲logo来源
@property (nonatomic, strong) NSString *coverImgUrl;            // 歌曲封面 URL
@property (nonatomic, strong) NSString *appName;                // 音频来源程序名称
@property (nonatomic, strong) NSString *appLogo;                // 音频来源程序logo
@property (nonatomic, strong) NSString *appType;                // 音频来源程序类型
@property (nonatomic, strong) NSString *business;               // 音频业务标识
@property (nonatomic, strong) NSString *epName;                 // 专辑名
@property (nonatomic, strong) NSString *webUrl;                 // 页面链接，原生音频播放器中的分享功能，分享出去的卡片简介，也将使用该值。
@property (nonatomic, assign) BOOL isRecordAudioPlayState;      // 是否支持断点续播
@property (nonatomic, assign) NSTimeInterval storeTime;         // 记录断点续播的时间戳

@property (nonatomic, copy) NSDictionary *extraDic;            // 扩展字段

@property(nonatomic, strong) NSString *bizIdentifier;          //业务标识

@end


