//
//  MPVisualTrackerUtils.h
//  MPVisualizationSDK
//
//  Created by panqifei on 2022/4/13.
//  Copyright © 2022 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <MPDataCenter/APDataCenter.h>

NS_ASSUME_NONNULL_BEGIN

static NSString *key_released = @"visualization_tracker_released";     // 已发布的配置数据
static NSString *key_debug = @"visualization_tracker_debug";           // 长连接下推送过来的配置数据

static NSString *business_visual = @"User_behavior_iOS";

@interface MPVisualTrackerUtils : NSObject

/// 存储可视化埋点配置信息
/// @param dictionary 组件list数据
/// @param key 投屏配置时为key_debug，发布时为key_released
+ (void)saveConfigWithWidgetsDic:(NSDictionary *)dictionary key:(NSString *)key;

/// 是否配置过该组件
/// @param widgetId 组件id
/// @param key 投屏配置时为key_debug，发布时为key_released
+ (BOOL)isDeployWidgetId:(NSString *)widgetId key:(NSString *)key;

/// 根据组件id获取eventId
/// @param widgetId 组件id
/// @param key 投屏配置时为key_debug，发布时为key_released
+ (NSString *)eventIdFromWidgetId:(NSString *)widgetId key:(NSString *)key;

/// 获取组件的属性信息
/// @param widgetId 组件id
/// @param key 投屏配置时为key_debug，发布时为key_released 
+ (NSDictionary *)attrbutesWithWidgetId:(NSString *)widgetId key:(NSString *)key;

/// 手动上报可视化已配置组件的埋点
/// @param view 组件
+ (void)visualWriteLogWithView:(UIView *)view;

@end

NS_ASSUME_NONNULL_END
