//
//  APLogTrackManager.h
//  APRemoteLogging
//
//  Created by majie on 16/10/27.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "APLogTrackAgent.h"

typedef enum {
    APLogTrackPageTypeNone = 0, // "none"
    APLogTrackPageTypeNative,   // "native"
    APLogTrackPageTypeH5,       // "h5"
    APLogTrackPageTypeTiny,     // "tiny"
} APLogTrackPageType;

@interface APLogTrackPageInfo : NSObject

@property (atomic, readonly, copy) NSString *pageId;
@property (atomic, readonly, copy) NSString *timestamp;
@property (atomic, readonly, copy) NSString *spmId;
@property (atomic, readonly, copy) NSString *information;
@property (atomic, readonly, assign) BOOL needRpc;

@end


@interface APLogTrackManager : NSObject

/**
 通知自动化埋点页面打开

 @param index 页面唯一标识,通常传入UIViewController的实例
 @param context 参数信息 \@ see APLogTrackContext
 */
+ (void)logPageStartWithIndex:(NSObject *)index context:(APLogTrackContext *)context pageType:(APLogTrackPageType)pageType;
+ (void)logPageStartWithIndex:(NSObject *)index context:(APLogTrackContext *)context __deprecated_msg("Deprecated, use 'logPageStartWithIndex:context:pageType:' instead.");

/**
 通知自动化埋点页面关闭
 
 @param index 页面唯一标识,需要保证此处传入的对象与调用[logPageStartWithIndex:context]时传入的index为同一个对象
 @param context 参数信息 \@ see APLogTrackContext
 */
+ (void)logPageEndWithIndex:(NSObject *)index pageType:(APLogTrackPageType)pageType;
+ (void)logPageEndWithIndex:(NSObject *)index __deprecated_msg("Deprecated, use 'logPageEndWithIndex:pageType:' instead.");

+ (void)logAutoClickWithContext:(APLogTrackContext *)context view:(UIView *)view pageType:(APLogTrackPageType)pageType;
+ (void)logAutoClickWithContext:(APLogTrackContext *)context view:(UIView *)view __deprecated_msg("Deprecated, use 'logAutoClickWithContext:view:pageType:' instead.");

+ (void)logPageDeallocWithIndex:(NSObject *)index pageType:(APLogTrackPageType)pageType;

+ (void)logPageUpdateWithIndex:(NSObject *)index context:(APLogTrackContext *)context;

+ (void)logPageUpdateWithIndex:(NSObject *)index context:(APLogTrackContext *)context updateType:(APLogTrackUpdateType)updateType;

+ (APLogTrackPageInfo *)pageInfoWithIndex:(NSObject *)index;

/**
 先上报指定页面的结束埋点，然后上报指定页面的开始埋点
 注意：
   页面结束埋点的页面信息使用之前的，页面开始埋点页面信息使用本次修改的；
   如果更新页面相关信息（slogSpmId，logEntityId、logExtendParam），更新后再调用该接口；
  
 @param vc        页面对象
 @param model 新的页面信息
 */
+ (void)logPageRestartWithViewController:(UIViewController *)vc eventModel:(AUKEventLogModel *)model;

/**
 上报切换前页面结束埋点，上报切换后页面开始埋点。
 注意：
   应用于非标准子页面切换情况
   fromVC和toVC调用前绑定eventLog_auk埋点信息
  
 @param fromVC   切换前页面，上报该页面结束埋点
 @param toVC       切换后页面，上报该页面开始埋点
 */
+ (void)logPageFromViewController:(UIViewController *)fromVC toViewController:(UIViewController *)toVC;

@end
