//
//  RVTraceDebugProtocol.h
//  AriverTraceDebug
//
//  Created by xyb on 2019/8/20.
//  Copyright © 2019 Alipay. All rights reserved.
//

#ifndef RVTraceDebugProtocol_h
#define RVTraceDebugProtocol_h

// 调试模式
typedef NS_ENUM(NSInteger,RVTraceDebugMode) {
    RVTraceDebugModeNone = 0,
    RVTraceDebugModeTrace,
    RVTraceDebugModeNet,
    RVTraceDebugModeExperience
};

@class RVTraceDataReporter;
@class RVKSession;

@protocol RVTraceDebugProtocol <NSObject>

/**
 通知端性能调试已开启
 */
- (void)onStart:(RVTraceDataReporter *)reporter session:(RVKSession *)session;

/**
 通知端性能调试已关闭
 */
- (void)onStop;

/**
 自定义基准时间(必须UTC时间 单位：毫秒)
 */
- (long long)baseTime;

/**
 退出当前小程序
 */
- (void)exitTinyAppWithSession:(RVKSession *)session;


@optional

/// 性能调试端控制开关
- (BOOL)disableTraceDebug;

/// 禁用默认CPU、内存、FPS性能数据采集，默认使用
- (BOOL)disableDefaultNativePerfCollector;

/// 切换ws通道地址
- (NSString *)forceSetWebSocketAddr;

/// 自定义端标识，不设置则使用默认端标识
- (NSString *)clientName;

/// 启用页面 DUMP
- (NSArray *)enableDumpPage;

/// 页面DUMP完成回调
/// @param timestamp dump时间点
/// @param imageData 截图信息
/// @param dumpInfo 页面结构
- (void)onDumpPage:(long long)timestamp
              imageData:(NSData *)imageData
               dumpInfo:(NSArray *)dumpInfo;

@end

#endif /* RVTraceDebugProtocol_h */
