//
//  RVTraceDataReporter.h
//  AriverTraceDebug
//
//  Created by xyb on 2019/8/22.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "RVTraceDataModel.h"

NS_ASSUME_NONNULL_BEGIN

@interface RVTraceDataReporter : NSObject

/**
 发送CPU数据

 @param value CPU数值
 @param pageUrl 页面url
 */

- (void)sendCPU:(NSString *)value
        pageUrl:(NSString *)pageUrl;

/**
 发送内存数据
 
 @param value 内存数值
 @param pageUrl 页面url
 */
- (void)sendMemory:(NSString *)value
           pageUrl:(NSString *)pageUrl;

/**
 发送FPS数据

 @param value FPS数值
 @param pageUrl 页面url
 */
- (void)sendFPS:(NSString *)value
        pageUrl:(NSString *)pageUrl;

/**
 发送启动耗时数据

 @param starttime 开始时间(UTC时间，单位毫秒)
 @param endtime 结束时间(UTC时间，单位毫秒)
 @param pageUrl 页面url
 */
- (void)sendLaunchTimeWithStarttime:(long long)starttime
                            endtime:(long long)endtime
                            pageUrl:(NSString *)pageUrl;

/**
发送网络请求数据

@param starttime 请求开始时间(UTC时间，单位毫秒)
@param endtime 请求响应时间(UTC时间，单位毫秒)
@param detail 详细数据
*/
- (void)sendNetworkWithStarttime:(long long)starttime
                         endtime:(long long)endtime
                          detail:(NSDictionary *)detail;

/**
 发送通用数据

 @param traceModel trace实例
 */
- (void)sendTraceData:(RVTraceDataModel *)traceModel;

/**
发送端自定义诊断项（已通过诊断项）

@param name 诊断项名称
@param measure 检测标准
@param diagnosis 诊断结果
@param suggestion 优化建议
*/
- (void)sendAuditDataWithName:(NSString *)name
                      measure:(NSString *)measure
                    diagnosis:(NSString *)diagnosis
                   suggestion:(NSString *)suggestion;

/**
发送端自定义诊断项（未通过诊断项）

@param name 诊断项名称
@param measure 检测标准
@param diagnosis 诊断结果
@param suggestion 优化建议
@param titles 表格标题
@param values 具体数据（二维数组，多行，每行有多个字段）
*/
- (void)sendAuditDataWithName:(NSString *)name
                      measure:(NSString *)measure
                    diagnosis:(NSString *)diagnosis
                   suggestion:(NSString *)suggestion
                       titles:(NSArray *)titles
                       values:(NSArray *)values;

@end

NS_ASSUME_NONNULL_END
