//
//  RVTraceDataModel.h
//  AriverTraceDebug
//
//  Created by xyb on 2019/8/20.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface RVTraceDataModel : NSObject

/**
 性能数据tag
 */
@property (nonatomic,   copy) NSString *tag;

/**
 性能数据name
 */
@property (nonatomic,   copy) NSString *name;

/**
 开始时间(毫秒)
 */
@property (nonatomic, assign) long long starttime;

/**
 结束时间(毫秒)
 */
@property (nonatomic, assign) long long endtime;

/**
 详细字段
 */
@property (nonatomic, strong) NSDictionary *detail;

// 禁止创建实例
- (instancetype)init UNAVAILABLE_ATTRIBUTE;

- (id)copy UNAVAILABLE_ATTRIBUTE;

+ (instancetype)allocWithZone:(struct _NSZone *)zone UNAVAILABLE_ATTRIBUTE;

+ (instancetype)new UNAVAILABLE_ATTRIBUTE;

/**
 初始化方法

 @param tag 性能数据类型
 @param name 性能数据名称
 @param detail 详细字段
 @return 实例
 */

- (instancetype)initWithTag:(NSString *)tag
                       name:(NSString *)name
                     detail:(NSDictionary *)detail;

/**
 初始化方法

 @param tag 性能数据类型
 @param name 性能数据名称
 @param starttime 开始时间(毫秒)
 @param endtime 结束时间(毫秒)
 @param detail 详细字段
 @return 实例
 */

- (instancetype)initWithTag:(NSString *)tag
                       name:(NSString *)name
                  starttime:(long long)starttime
                    endtime:(long long)endtime
                     detail:(NSDictionary *)detail;

@end

NS_ASSUME_NONNULL_END
