//
//  TABarButtonItem.h
//  TinyappService
//
//  Created by 闻蹊 on 2018/4/26.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <AriverNebulaBiz/TABaseBarButtonItem.h>
#import <AriverNebulaBiz/TAColorDefines.h>

typedef NS_ENUM(NSUInteger, TABarButtonItemStyle) {
    TABarButtonItemStyleNormal = 0,
    TABarButtonItemStyleLine = 1
};

typedef NS_ENUM(NSInteger, TABarButtonIconType) {
    TABarButtonIconTypeUnkown = 0,
    TABarButtonIconTypeDefault = 1,
    TABarButtonIconTypeBluetooth = 2,
    TABarButtonIconTypeLocation = 3,
    TABarButtonIconTypeAudio = 4,
    TABarButtonIconTypeVideo = 5
};

@interface TABarButtonItem : TABaseBarButtonItem

@property (nonatomic, assign) TABarButtonIconType currentIconType;

- (instancetype)initWithFrame:(CGRect)frame style:(TABarButtonItemStyle)style;
- (void)addTagert:(id)tagert action:(SEL)action;
- (void)addLongGestureTarget:(id)target action:(SEL)action;
- (void)setCustomIcon:(NSString *)imageSrc context:(PSDContext *)context;
- (void)setImage:(UIImage *)image;
- (void)setImage:(UIImage *)image text:(NSString *)text;
- (void)setText:(NSString *)text;
- (void)changeTintColor:(BOOL)isLight;
- (void)showNoticeMessage:(nullable NSDictionary *)badgeInfo;

// 默认无限次，count 设置为 -1 也是无限次
- (void)setAnimationRepeat:(CGFloat)count;
- (void)startAnimation;
- (void)stopAnimation;

@end
