//
//  RVTAppRuntime.h
//  AriverRuntime
//
//  Created by 浪浪 on 2020/6/23.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AriverKernel/RVKSession.h>
#import "RVTJSCManager.h"
#import <AriverResource/RVRApp.h>

NS_ASSUME_NONNULL_BEGIN


@interface RVTAppRuntime : NSObject

// 当前运行App worker实例，只有小程序会启动worker
@property(nonatomic, strong)RVTJSCManager *jscWorker;
@property(nonatomic, weak)RVKSession *session;

//appInfo
//appManager

/**
 *  当前session包信息
 */
- (RVRApp *)appInfo;

- (instancetype)initWithSession:(RVKSession *)session;

/**
 *  当前session实例appId,
 *  若当前session是小程序/h5离线应用，返回应用appId, 若当前实例是插件，返回插件宿主appId
 */
- (NSString *)currentAppId;

/**
 * 获取当前session启动参数
 */
- (id)getStartParam:(NSString *)paramKey;

@end

NS_ASSUME_NONNULL_END
