//
//  RVRInterface.h
//  AriverResource
//
//  Created by Jiangling Zheng on 2020/6/4.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "RVRProtocol.h"

NS_ASSUME_NONNULL_BEGIN

@interface RVRInterface : NSObject

+ (instancetype)shared;

// 禁止创建实例
+ (instancetype)new UNAVAILABLE_ATTRIBUTE;

+ (instancetype)alloc UNAVAILABLE_ATTRIBUTE;

+ (instancetype)allocWithZone:(struct _NSZone *)zone UNAVAILABLE_ATTRIBUTE;

- (instancetype)init UNAVAILABLE_ATTRIBUTE;

- (id)copy UNAVAILABLE_ATTRIBUTE;


// 注入实现
- (void)injectRequestManager:(id<RVRRequestManagerDelegate>)manager forKey:(NSString *)key;

// 根据入参获取对应的delegate对象
- (id<RVRRequestManagerDelegate>)getRequestManagerByParam:(NSDictionary *)param;

@end

NS_ASSUME_NONNULL_END
