//
//  NBWebImageAdvisor
//  解耦 图片下载(APWebImage)
//  Created by 张光宇 on 2019/7/26.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

typedef void(^NBWebImageCompletionBlock)(UIImage * _Nullable image, NSError * _Nullable error);
typedef void(^NBImageLoaderCompletedBlock)(UIImage * _Nullable image, NSData * _Nullable data, NSError * _Nullable error, BOOL finished);

@protocol NBWebImageAdvisor <NSObject>

- (void)imageView:(UIImageView *_Nonnull)imageView setImageWithURL:(nullable NSURL *)url;
- (void)imageView:(UIImageView *_Nonnull)imageView setImageWithURL:(NSURL *)url placeholderImage:(UIImage *)placeholder;

- (void)button:(UIButton *_Nonnull)button
setBackgroundImageWithURL:(nullable NSURL *)url
      forState:(UIControlState)state;

- (void)button:(UIButton *_Nonnull)button
setBackgroundImageWithURL:(nullable NSURL *)url
      forState:(UIControlState)state
     completed:(nullable NBWebImageCompletionBlock)completedBlock;

- (void)button:(UIButton *_Nonnull)button
setImageWithURL:(nullable NSURL *)url
      forState:(UIControlState)state
     completed:(nullable NBWebImageCompletionBlock)completedBlock;


- (nullable id)downloadImageWithURL:(nullable NSURL *)url
                                                 completed:(nullable NBImageLoaderCompletedBlock)completedBlock;

@optional
- (nullable NSData *)createHttpDataWithLocalId:(nonnull NSString *)localId type:(nonnull NSString *)type;

- (nullable NSString *)getLocalUrlWithLocalId:(nonnull NSString *)localId type:(nonnull NSString *)type;

- (nullable UIImage *)imageWithWebPData:(nonnull NSData *)data;
- (nullable UIImage *)imageWithAnimatedGIFData:(nonnull NSData *)data;
- (nullable UIImage *)imageWithHEVCData:(nonnull NSData *)data;

//my.compressImage需要
- (nullable NSString *)compressImageFromLocalID:(nonnull NSString *)localId options:(nonnull NSDictionary *)options;

- (nullable NSString *)getLocalIdWithImageData:(nonnull NSData *)imageData options:(nonnull NSDictionary *)options;
@end
