//
//  PSDInvocationEvent.h
//  Poseidon
//
//  Created by chenwenhong on 14-8-11.
//  Copyright (c) 2014年 Alipay. All rights reserved.
//

#import "PSDEvent.h"
#import "PSDJsApi.h"

@interface PSDInvocation: NSObject

@property (nonatomic, assign) NSUInteger uniqueId;

@end

@interface PSDInvocationEvent : PSDEvent

@property(nonatomic, readonly, copy) NSString                           *invocationName;
@property(nonatomic, strong) NSDictionary                     *invocationData; //当前携带的数据对象
@property(nonatomic, strong) NSDictionary                               *invocationResult; // 返回结果
@property(nonatomic, readonly, copy) NSString                           *url;
@property(nonatomic, readonly, strong) PSDJsApi                         *jsApi;
@property(nonatomic, readonly, strong) PSDJsApiResponseCallbackBlock    responseCallback;
@property(nonatomic, copy) NSString                                     *invocationSource;//调用来源
@property(nonatomic, assign) BOOL                                       shouldSkipCallback;//是否跳过执行responseCallback
@property(nonatomic, strong) PSDInvocation                              *invocation; // 用于跟踪一次JSAPI的调用至完成
@property (nonatomic, assign) BOOL                                      isOnlyForWorker; //只给worker发的事件
@property (nonatomic, readonly) BOOL                                    isFallbackSearchEnabled; //指定jsApi搜索平台时，是否进行兜底

// 内部做开关，调用约束
- (void)mPaaS_setInvocationData:(NSDictionary *)invocationData;

+ (instancetype)allEvent:(NSString *)invocationName url:(NSString *)url;

#pragma mark - API
// can preventDefault
+ (instancetype)startEvent:(NSString *)invocationName
                invocation:(PSDInvocation *)invocation
            invocationData:(NSDictionary *)invocationData
                       url:(NSString *)url;

+ (instancetype)invokeBeforeEvent:(NSString *)invocationName
                       invocation:(PSDInvocation *)invocation
                   invocationData:(NSDictionary *)invocationData
                              url:(NSString *)url
                            jsApi:(PSDJsApi *)jsApi
                 responseCallback:(PSDJsApiResponseCallbackBlock)responseCallback;

+ (instancetype)invokePermitEvent:(NSString *)invocationName
                       invocation:(PSDInvocation *)invocation
                   invocationData:(NSDictionary *)invocationData
                              url:(NSString *)url
                            jsApi:(PSDJsApi *)jsApi
                 responseCallback:(PSDJsApiResponseCallbackBlock)responseCallback;
// can preventDefault and can invoke custom yourself(you should set invocationResult to responseCallback)
+ (instancetype)invokeEvent:(NSString *)invocationName
                 invocation:(PSDInvocation *)invocation
             invocationData:(NSDictionary *)invocationData
                        url:(NSString *)url
                      jsApi:(PSDJsApi *)jsApi
           responseCallback:(PSDJsApiResponseCallbackBlock)responseCallback;

+ (instancetype)completeEvent:(NSString *)invocationName
                   invocation:(PSDInvocation *)invocation
             invocationResult:(NSDictionary *)invocationResult
                          url:(NSString *)url  DEPRECATED_ATTRIBUTE; // 废弃方法，请使用下面方法

+ (instancetype)completeEvent:(NSString *)invocationName
                   invocation:(PSDInvocation *)invocation
               invocationData:(NSDictionary *)invocationData
             invocationResult:(NSDictionary *)invocationResult
                          url:(NSString *)url;

+ (instancetype)errorEvent:(NSString *)invocationName invocation:(PSDInvocation *)invocation url:(NSString *)url;

+ (instancetype)startEvent:(NSString *)invocationName
            invocationData:(NSDictionary *)invocationData
                       url:(NSString *)url;

+ (instancetype)invokeBeforeEvent:(NSString *)invocationName
                   invocationData:(NSDictionary *)invocationData
                              url:(NSString *)url
                            jsApi:(PSDJsApi *)jsApi
                 responseCallback:(PSDJsApiResponseCallbackBlock)responseCallback;

+ (instancetype)invokePermitEvent:(NSString *)invocationName
                   invocationData:(NSDictionary *)invocationData
                              url:(NSString *)url
                            jsApi:(PSDJsApi *)jsApi
                 responseCallback:(PSDJsApiResponseCallbackBlock)responseCallback;
// can preventDefault and can invoke custom yourself(you should set invocationResult to responseCallback)
+ (instancetype)invokeEvent:(NSString *)invocationName
             invocationData:(NSDictionary *)invocationData
                        url:(NSString *)url
                      jsApi:(PSDJsApi *)jsApi
           responseCallback:(PSDJsApiResponseCallbackBlock)responseCallback;

+ (instancetype)completeEvent:(NSString *)invocationName
             invocationResult:(NSDictionary *)invocationResult
                          url:(NSString *)url  DEPRECATED_ATTRIBUTE; // 废弃方法，请使用下面方法

+ (instancetype)completeEvent:(NSString *)invocationName
               invocationData:(NSDictionary *)invocationData
             invocationResult:(NSDictionary *)invocationResult
                          url:(NSString *)url;

+ (instancetype)errorEvent:(NSString *)invocationName url:(NSString *)url;

#pragma mark - Event
+ (instancetype)startEvent:(NSString *)invocationName
                 eventData:(NSDictionary *)invocationData
                       url:(NSString *)url;

@end
