//
//  NBNUtils.h
//  NebulaNetwork
//
//  Created by runfeng.crf on 2019/2/11.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AriverNebulaPoseidon/NebulaPoseidon.h>
#import <AriverNebula/H5WebViewController.h>
#import <AntUI/AntUI.h>

NS_ASSUME_NONNULL_BEGIN

NSString * NBNString(id string);
NSNumber * NBNNumber(id number);
NSArray * NBNArray(id array);
NSDictionary * NBNDictionary(id dic);
NSString * NBNJsonStr(NSDictionary * dic);
NSDictionary * NBNJsonDic(NSString * jsonStr);
NSDictionary * NBNJsonDicWithData(NSData *data);

void NBNLogInfo(NSString* format,...);

@interface NBNUtils : NSObject

+ (BOOL)isTinyAppWithSession:(PSDSession*)session;
+ (BOOL)isInnerTinyApp:(NSString *)appId;
+ (BOOL)isTinyAppWithStartParams:(NSDictionary *)startParam;

+ (void)syncCookieWithHeaders:(NSDictionary *)headers psdView:(PSDView *)psdView responseUrl:(NSURL *)responseUrl;

@end

#ifdef ENABLE_DEPENDENCY_MOCK

@interface TAWebViewUtils : NSObject

+ (BOOL)isEmbeddedWebViewWith:(PSDSession*)session;

+ (NSString*)parentAppIdWith:(PSDSession*)session;

+ (BOOL)canEmbedWebViewOpenOfflinePackge:(NSString *)packageAppid
                               tinyAppId:(NSString *)tinyAppid;
@end


@interface H5WebViewController (NebulaNetworkDeclare)

- (BOOL)isApplet;
- (BOOL)isH5App;

@end

#endif

NS_ASSUME_NONNULL_END
