//
//  RVALoggerService.h
//  AriverDemo
//
//  Created by 章海滨 on 2019/4/16.
//  Copyright © 2019 alipay.com. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AriverApp/RVALogger.h>


@protocol RVALoggerBehaviorDelegate <NSObject>
- (void)behaviorWithData:(NSDictionary *)data contentView:(RVKContentView *)contentView callback:(PSDJsApiResponseCallbackBlock)callback;
@end


@interface RVALoggerService : NSObject<RVALoggerDelegate>

+ (instancetype) sharedInstance;

@property(nonatomic, weak) id<RVALoggerBehaviorDelegate> behaviorDelegate;

- (void)errorWithType:(NSString *)type code:(NSString *)code msg:(NSString *) msg commonDatas:(NSDictionary *)commonDatas extDatas:(NSDictionary *)extDatas;

- (void)performanceWithType:(NSString *)type commonDatas:(NSDictionary *)commonDatas properties:(NSDictionary *)properties stages:(NSDictionary *)stages events:(NSDictionary *)events;

- (void)behaviorWithType:(NSString *)type commonDatas:(NSDictionary *)commonDatas extDatas:(NSDictionary *)extDatas currentVC:(id)currentVC;

- (void)behaviorWithData:(NSDictionary *)data contentView:(id)contentView callback:(RVKJsApiResponseCallbackBlock)callback;;

@end
