//
//  TATempUtils.h
//  NebulaBiz
//
//  Created by lyusheng on 2019/2/22.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef enum {
    NavigationBarStyleH5 = 0,
    NavigationBarStyleTinyApp
} NavigationBarStyle;

@class RVRApp;

@interface TATempUtils : NSObject

+(BOOL)isMiniServerWithApp:(DTMicroApplication *)app;

+ (NSString *)parentIdWithMiniServer:(DTMicroApplication *)app;

+ (BOOL)isHomePage:(H5WebViewController *)vc curApp:(NAMApp *)app;

//////// -------来自
//
+ (BOOL)configParamResultWithKey:(NSString *)key
                           appId:(NSString *)appId;

+ (BOOL)usePresetPopMenu:(NSDictionary *)extendInfo;


+ (BOOL)isH5ConvertToTinyAppStyle:(NSString *)appId;

+ (BOOL)isOnlyOptionMenuWithLaunchParams:(NSDictionary *)launchParams
                             application:(DTMicroApplication *)app;

+ (BOOL)isTinyAppWithApp:(id)app;

/**
 * 容器app实例导航栏样式，
 *  @param RVRApp 包信息
 */

+ (NavigationBarStyle)navigationBarStyle:(RVRApp *)app;

@end

NS_ASSUME_NONNULL_END
