//
//  NAMTinyAppConfig.h
//  NebulaAppManager
//
//  Created by runfeng.crf on 2019/4/10.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSUInteger, NAMTinyAppConfigScope) {
    NAMTinyAppConfigScopeUnknown = 0,
    NAMTinyAppConfigScopeGlobal = 1,
    NAMTinyAppConfigScopeApp
};

@interface NAMTinyAppConfig : NSObject

+ (instancetype)configs;

/**
 获取某一个小程序的某项配置。优先查找小程序维度的配置，如果未找到，会在全局维度配置中查找
 */
- (NSString *)getConfig:(NSString *)appId key:(NSString *)key;

/**
 在指定的scope中获取某一个小程序的某项配置
 */
- (NSString *)getConfig:(NSString *)appId key:(NSString *)key scopeType:(NAMTinyAppConfigScope)scope;

/**
 全量设置某个小程序的所有配置项，覆盖之前的数据
 @param configs 配置项，key为配置Id，例如“api_permission”等；value为dict，包括配置类型、配置值、md5等
 @param appId 小程序appId
 */
- (void)setAppConfigs:(NSDictionary *)configs appId:(NSString *)appId;

/**
 全量设置全局的小程序配置
 @param configs 配置项，key为配置Id，例如“api_permission”等；value为dict，包括配置类型、配置值、md5等
 */
- (void)setGlobalConfigs:(NSDictionary *)configs;

/**
 根据包信息rpc返回的数据，更新小程序维度和全局维度配置
 @param configs rpc返回的配置数据
 @param appId 小程序appId
 */
- (void)updateConfigs:(NSDictionary *)configs appId:(NSString *)appId;

/**
 根据包信息rpc返回的数据，更新小程序维度和全局维度配置
 @param configs rpc返回的配置数据
 @param appId 小程序appId
 @param appId 是否来自于sync的更新
 */
- (void)updateConfigs:(NSDictionary *)configs appId:(NSString *)appId fromSync:(BOOL)isFromSync;

@end
