//
//  RVMapComponent.h
//  NebulaPlugins
//
//  Created by theone on 17/3/13.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AriverRuntime/RVTComponent.h>
#import <AriverApp/RVAComponentProtocol.h>

//********************** message **************************//
#define kMarkerTap       @"bindmarkertap"
#define kControlTap      @"bindcontroltap"
#define kRegionChange    @"bindregionchange"
#define kTap             @"bindtap"
#define kCallouttap      @"bindcallouttap"
#define kPoiTap          @"bindpoitap"
#define kMapinitcomplete @"bindmapinitcomplete"
#define kAnimationEnd    @"animationEnd"
#define kMarkermoveend   @"bindmarkermoveend"
#define kMarkermove      @"bindmarkermove"
#define kPolylinemoveend @"bindpolylinemoveend"
#define kSkewchange      @"bindskewchange"
#define kFrametap        @"bindpaneltap"
#define kMaprestorecomplete  @"bindmaprestorecomplete"
#define kMaploadingerror @"bindmaploadingerror"


NS_ASSUME_NONNULL_BEGIN


typedef void (^RVMapComponentImageCallback)(UIImage * _Nullable image, NSData * _Nullable imageData);
typedef void (^TransforJSPolylinesCallback)(NSArray *polyLines);

@class RVMapView;
@interface RVMapComponent : RVTComponent
@property (nonatomic, copy) NSString *appId;
@property (nonatomic,strong) RVMapView *mapView;
@property (nonatomic,assign) RVMapEngine mapEngine;
@property (nonatomic, strong) UIView *mapContentView;
- (instancetype)initWithAppId:(NSString *)appId;
- (void)handleSendMessage;
- (void)sendMessage:(NSString *)message data:(NSDictionary *)data;
- (void)requestImageResource:(NSString*)url size:(CGSize)size needSync:(BOOL)bSync callback:(RVMapComponentImageCallback)callback;
@end

@interface RVMapComponent (JsApi)
- (void)componentReceiveMessage:(NSString *)message data:(NSDictionary *)data callback:(RVAComponentCallback)callback;
- (BOOL)needMapStyleV7;
@end

@interface RVMapComponent (PropertyFunction)
- (void)componentDataDidChangeWithData:(NSDictionary *)data;
- (void)updateComponentsWithData:(NSDictionary *)data callback:(void (^)(NSDictionary *))callback;
@end

@interface RVMapComponent (Transfor)
- (NSString *)getMarkerIdWithData:(NSDictionary *)data;
- (void)transforJSMark:(NSDictionary *)mark callback:(void (^)(RVMapAnnotation *addedMarker,NSString *iconUrl))callback;
- (void)transforJSMarks:(NSArray *)marks createClusterTree:(BOOL)needCreate callback:(void (^)(RVMapAnnotation *addedMarker,NSString *iconUrl,BOOL isLast))callback;
- (id<RVMapPolylineProtocol>)transforJSPolyline:(NSDictionary *)polyline;
- (void)transforJSPolylines:(NSArray *)polylines callback:(TransforJSPolylinesCallback)callback;
- (NSArray *)transforJSControls:(NSArray *)controls;
- (NSArray *)transforJSPolygon:(NSArray *)polygones;
- (NSArray *)transforCircles:(NSArray *)circles;
- (void)transforTileOverLays:(NSDictionary *)overLays;
- (void)transforGroundOverLays:(NSArray *)overLays;
- (RVMapTranslateAnnotation *)transforJSTranslateMarker:(NSDictionary *)dataDic;
- (void)transforJSSmoothMoveMarker:(NSDictionary *)dataDic callback:(void (^)(RVMapMoveMarkerModel *))callback;
- (void)transforStyle1_2:(NSDictionary *)obj callback:(void(^)(NSDictionary *styleDic))callback;
- (void)transforStyle3:(NSDictionary *)obj callback:(void(^)(NSDictionary *styleDic))callback;
- (void)transforStyle4:(NSDictionary *)obj markerId:(NSString *)markerId callback:(void(^)(NSDictionary *styleDic))callback;
- (RVMapCommonMapLabel *)transforLabelModel:(NSDictionary *)labelDic;
- (NSString *)transforColorStrToArgbWithColorStr:(NSString *)colorStr;
- (RVMapOverlayLevel)overlayLevel:(id)obj;
- (NSMutableArray *)transforDesc:(NSArray *)descList;
- (void)transforRoutePlanRequest:(NSDictionary *)data callback:(void(^)(RVMapRoutePlanRequest *result))callback;
- (CGRect)getRectFormDic:(NSDictionary *)dic;
@end

@interface RVMapComponent (Log)
- (float)p_updateFloatValue:(float)floatValue withObj:(id)value mapCode:(NSInteger)mapCode;
- (double)p_updateDoubleValue:(double)doubleValue withObj:(id)value mapCode:(NSInteger)mapCode;
- (NSString *)p_updateStringValue:(NSString *)stringValue withObj:(id)value mapCode:(NSInteger)mapCode;
- (void)p_logParamError:(NSInteger)mapCode param:(id)param;
- (void)p_logJsapiParamError:(NSString *)jsapi;
- (void)p_logJsapiError:(NSInteger)errorCode errorMessage:(NSString *)errorMessage jsApi:(NSString *)jsApi;
- (void)p_logJsApiExecutionTime:(NSDate *)startTime jsapi:(NSString *)jsapi;
@end

NS_ASSUME_NONNULL_END
