//
//  RVZebraView.h
//  APMap
//
//  Created by 百喻 on 2019/8/21.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

typedef void(^RVZebraViewClickBlock)(NSString* clickId);

@class RVZebraView;

@protocol RVZebraViewDelegate <NSObject>
@required
- (void)RVZebraViewLoading:(RVZebraView *)RVZebraView;
- (void)RVZebraViewDidLoad:(RVZebraView *)RVZebraView;
@end

@interface RVZebraView : UIView
- (instancetype)initWithConfig:(NSDictionary *)config
             enableTextAutoFit:(BOOL)enable
                    dataSource:(id <RVZebraDataSource>)dataSource
                      delegate:(id <RVZebraViewDelegate>)delegate;
@property (nonatomic) RVZebraViewClickBlock clickBlock;
@property (nonatomic) BOOL clickable;
@end

NS_ASSUME_NONNULL_END
