//
//  RVZebraInterface.h
//  APMap
//
//  Created by 百喻 on 2019/9/23.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

// error code
const static NSInteger kZEBRA_ERROR_NONE             = 0;
const static NSInteger kZEBRA_ERROR_PARSE            = 1001;
const static NSInteger kZEBRA_ERROR_LAYOUT           = 1002;
const static NSInteger kZEBRA_ERROR_REQUEST          = 1003;


@class RVZebraInterface;
@class RVZebraView;
@class RVZebraInterfaceModel;
@protocol RVZebraDataSource;

NS_ASSUME_NONNULL_BEGIN
// isLoaded: YES:所有src加载完毕。 NO:placeholder 加载完毕, src正在加载
typedef void (^RVZebraViewDidLoadBlock)(RVZebraView * _Nullable RVZebraView,BOOL isLoaded,NSInteger errorCode);

@interface RVZebraInterface : NSObject
@property (nonatomic,copy) NSString *appId; // 用于埋点
- (void)runWithConfig:(RVZebraInterfaceModel *)config dataSource:(id<RVZebraDataSource>)dataSource viewDidLoad:(RVZebraViewDidLoadBlock)viewDidLoad;
@end

NS_ASSUME_NONNULL_END
