//
//  RVMapPerformanceLogger.h
//  APMap
//
//  Created by 百喻 on 2019/4/10.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

// 埋点文档:https://yuque.antfin-inc.com/docs/share/e31c224d-a0d7-4c87-9edf-5f3d1d763a12

NS_ASSUME_NONNULL_BEGIN

@interface RVMapPerformanceLogger : NSObject

+ (void)map_logJsApiExecutionTimeWithStart:(NSDate *)start jsApi:(NSString *)jsApi appId:(NSString *)appId;

+ (void)map_logJsApiLaunchTimeWithStart:(NSDate *)start jsApi:(NSString *)jsApi appId:(NSString *)appId;

+ (void)map_logCreateMapTimeWithStart:(NSDate *)start appId:(NSString *)appId;

+ (void)map_logLoadMapTimeWithStart:(NSDate *)start appId:(NSString *)appId;

+ (void)map_logDoLocationWithStart:(NSDate *)start appId:(NSString *)appId;

+ (void)map_logMarkerLimit:(NSInteger)count appId:(NSString *)appId;

+ (void)map_logSmoothMoveMarkerDelayRatio:(CGFloat)delayRatio appId:(NSString *)appId;

+ (void)map_logSmoothMovePolylineDelayRatio:(CGFloat)delayRatio appId:(NSString *)appId;

// type: 1 解析耗时 2 布局耗时 3 资源加载
+ (void)map_logZebraCostWithStartTime:(NSDate *)start type:(int)type appId:(NSString *)appId;

+ (void)map_logClusterPerfWithCost:(NSTimeInterval)cost allCount:(int)allCount rootCount:(int)rootCount appId:(NSString *)appId;

+ (void)map_logReplayJSAPICount:(NSInteger)count appId:(NSString *)appId;

@end

NS_ASSUME_NONNULL_END
