//
//  RVMapCommonMapMarkerViewConfig.h
//  APMap
//
//  Created by jinzhidong on 2018/9/19.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

#define kMarkerSpaceWidthKey     @"kMarkerSpaceWidthKey"        // marker的除文字之外的两边宽度
#define kMarkerHeightKey         @"kMarkerHeightKey"            // marker的高度
#define kMarkerTextLeftSpaceKey  @"kMarkerTextLeftSpaceKey"     // marker的文字距离左边的距离
#define kMarkerTextHeightKey     @"kMarkerTextHeightKey"        // marker的文字高度
#define kMarkerIconLeftSpaceKey  @"kMarkerIconLeftSpaceKey"     // marker的图标距离左边的距离
#define kMarkerIconSizeKey       @"kMarkerIconSizeKey"          // marker的图标大小
#define kMarkerRadiusKey         @"kMarkerRadiusKey"            // marker的弧度
#define kMarkerArrorHeightKey    @"kMarkerArrorHeightKey"       // marker的箭头高度
#define kMarkerDotRadiusKey      @"kMarkerDotRadiusKey"         // marker下面标记点的半径
#define kMarkerLineWidthKey      @"kMarkerLineWidthKey"         // marker的边框宽度
#define kMarkerLeftImgRectKey    @"kMarkerLeftImgRectKey"       // marker的左侧图标的rect

#define kMarkerTextFontSizeKey   @"kMarkerViewTextFontSizeKey"  // marker的文字字号
#define kMarkerStrokeColorKey    @"kMarkerStrokeColorKey"       // marker的边框颜色
#define kMarkerFillColorKey      @"kMarkerFillColorKey"         // marker的填充颜色
#define kMarkerDotFillColorKey   @"kMarkerDotFillColorKey"      // marker下面标记点的颜色

#define kMarkerType3ViewRectKey  @"kMarkerType3ViewRectKey"      // type=3类型的尺寸
#define kMarkerType3IconRectKey  @"kMarkerType3IconRectKey"      // type=3类型的图标尺寸
#define kMarkerType3LabelRectKey @"kMarkerType3LabelRectKey"     // type=3类型的文字显示区域尺寸
#define kMarkerType3FontSizeKey  @"kMarkerType3FontSizeKey"      // type=3类型的文字显示的字号
#define kMarkerType3LabelBoard 5


// 用来设置地图自定义marker的配置，目前有两种样式：type=1的默认态和type=2的点击态
// 这里就配置展示UI相关的各种数值
@interface RVMapCommonMapMarkerViewConfig : NSObject

// 获取当前支持的自定义marker的配置,type=1和type=2
+ (NSDictionary *)markerViewConfigType1_2;

// 获取当前支持的自定义marker的配置,type=3
+ (NSDictionary *)markerViewConfigType3:(NSString *)fontType;

// 根据gravity获取当前展示的文字排列方式,type=3
+ (NSTextAlignment)getTextAlignment4Type3:(NSString *)gravity;

// 是否是type1和type2的类型
+ (BOOL)hasType1_2:(NSString *)type;

// 是否是type3的类型
+ (BOOL)hasType3:(NSString *)type;

+ (BOOL)hasType4:(NSString *)type;

+ (UIImage *)genarateMarkerImage4Type1_2WithData:(NSDictionary *)dic;

+ (UIImage *)genarateMarkerImage4Type3WithData:(NSDictionary *)dic;

@end
