//
//  RVMapBussinessLogger.h
//  APMap
//
//  Created by 百喻 on 2019/4/10.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

// 埋点文档:https://yuque.antfin-inc.com/docs/share/e31c224d-a0d7-4c87-9edf-5f3d1d763a12

NS_ASSUME_NONNULL_BEGIN
static NSString *const kLogError                    = @"error";
static NSString *const kLogErrorMsg                 = @"errorMessage";

// 定位失败数 mapCode
const static NSInteger kCODE_DO_LOCATION            = 1;
const static NSInteger kCODE_MOVE_LOCATION          = 2;
const static NSInteger kCODE_GET_CENTER_LOCATION    = 3;

// 参数异常量 mapCode
const static NSInteger kCODE_MARKER                 = 1;
const static NSInteger kCODE_SCALE                  = 2;
const static NSInteger kCODE_LAT_LON                = 3;
const static NSInteger kCODE_CONTROLS               = 4;
const static NSInteger kCODE_TILE_OVERLAY           = 5;
const static NSInteger kCODE_POLYLINE               = 6;
const static NSInteger kCODE_POLYGON                = 7;
const static NSInteger kCODE_CIRCLES                = 8;
const static NSInteger kCODE_GROUNDOVERLAY          = 9;

// renderAbroad mapCode
const static NSInteger kCODE_RA_UNUSE               = 0;   // 不使用海外地图
const static NSInteger kCODE_RA_GRILLE              = 1;   // 格栅图
const static NSInteger kCODE_RA_VECTOR              = 2;   // 矢量图

// mapEvent
static NSString *const kEVENT_RENDERMAP             = @"renderMap";
static NSString *const kEVENT_RENDERDSL             = @"renderDSL";
static NSString *const kEVENT_MAPSTYLE              = @"mapStyle";
static NSString *const kEVENT_LOCATION              = @"location";
static NSString *const kEVENT_MAPBOX                = @"mapbox";

//
const static NSInteger kEVENT_CODE_SUCCESS          = 1;
const static NSInteger kEVENT_CODE_FAIL             = 2;

// ZebraSource
const static NSInteger kZEBRA_SOURCE_MARKER         = 1;
const static NSInteger kZEBRA_SOURCE_CALLOUT        = 2;
const static NSInteger kZEBRA_SOURCE_PANELS         = 3;

// DelayEventCode
const static NSInteger kEVENT_CODE_CREATE           = 1;
const static NSInteger KEVENT_CODE_RELEASE          = 2;


@interface RVMapBussinessLogger : NSObject

+ (void)map_logJsApiCall:(NSString *)jsApi appId:(NSString *)appId;

+ (void)map_logRenderAbroadWithMapCode:(NSInteger)mapCode appId:(NSString *)appId;

+ (void)map_logJsApiError:(NSString *)jsApi errorInfo:(NSDictionary *_Nullable)errorInfo appId:(NSString *)appId;

+ (void)map_logLoadMapError:(NSInteger)errorCode responseCode:(NSInteger)responseCode appId:(NSString *)appId;

+ (void)map_logParamError:(NSInteger)mapCode appId:(NSString *)appId;

+ (void)map_logTinyAppMapEvent:(NSString *)event mapCode:(NSInteger)mapCode appId:(NSString *)appId;

+ (void)map_logNativeMapEvent:(NSString *)event mapCode:(NSInteger)mapCode appId:(NSString *)appId;

+ (void)map_logZebraWithMapCode:(NSInteger)mapCode source:(NSInteger)source appId:(NSString *)appId;

+ (void)map_logDelayEventWithCode:(NSInteger)mapCode appId:(NSString *)appId;

+ (void)map_logEvent:(NSString *)event mapCode:(NSInteger)mapCode appId:(NSString *)appId;

@end

NS_ASSUME_NONNULL_END
