//
//  RVMapAnnotationView.h
//  AriverMap
//
//  Created by 百喻 on 2020/3/10.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@class RVMapCalloutView;
@class RVMapCommonMapLabel;
@class RVMapCalloutModel;

typedef void(^RVMapAnnotationViewClick)(id<RVMapAnnotationProtocol> annotation);
typedef void(^RVMapAnnotationCalloutClick)(id<RVMapAnnotationProtocol> annotation, NSString *clickId);



@protocol RVMapAnnotationViewProtocol <NSObject>
@property (nonatomic, strong) UIImage *image;
@property (nonatomic) CGPoint calloutOffset;
@property (nonatomic, assign) BOOL canShowOnTap;
@property (nonatomic) CGPoint centerOffset;
@property (nonatomic, assign) NSInteger zIndex;

// callout
@property (nonatomic) BOOL canShowCallout;
@property (nonatomic, strong) RVMapCalloutView *calloutView;
@property (nonatomic, assign) BOOL isCustomCallout;
@property (nonatomic, strong) RVMapCalloutModel *calloutData;
@property (nonatomic, strong) id<RVMapAnnotationProtocol> annotation;
@property (nonatomic, copy) RVMapAnnotationViewClick annotationClickBlock;
@property (nonatomic, copy) RVMapAnnotationCalloutClick calloutClickBlock;


- (void)showCustomCallout;
- (void)hiddenCustomCallout;
- (void)setButtonEnabled:(BOOL)enabled;
-(void)setLeftIconWithImage:(UIImage *)image isShow:(BOOL)yesOrNo;

-(void)judgeCalloutBoundsWithDesc:(NSString *)str subDesc:(NSString *)subDesc withCalloutType:(NSInteger)type;

- (void)judgeLabelBoundsWithDesc:(NSString *)str fontSize:(CGFloat)fontSize padding:(CGFloat)padding;

- (void)updateWithCalloutData:(RVMapCalloutModel *)calloutData;

- (void)resetLeftIconImageViewRect:(CGRect)rect;
@end

@interface RVMapAnnotationView : UIView <RVMapAnnotationViewProtocol>
- (instancetype)initWithFrame:(CGRect)frame annotation:(id<RVMapAnnotationProtocol>)annotation;

@end

NS_ASSUME_NONNULL_END
