//
//  RVMAMapMarker.h
//  APMap
//
//  Created by 去疾 on 17/3/28.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>

@class RVMapMoveMarkerModel;
@class RVMapCallout;
@class RVMapCommonMapLabel;
@class RVZebraView;

typedef NS_ENUM(NSInteger,RVMAMarkerAniCallbackType) {
    RVMAMarkerAniCallbackTypeChangeRotation,
    RVMAMarkerAniCallbackTypeChangeLatLng,
    RVMAMarkerAniCallbackTypeTargetDistance,
    RVMAMarkerAniCallbackTypeStop,
    RVMAMarkerAniCallbackTypeFinished
};
typedef void(^RVMAMarkerAniCallback)(RVMAMarkerAniCallbackType type, NSDictionary* data);


@protocol RVMapAnnotationProtocol <NSObject>
@property (nonatomic,strong) NSNumber *identifier;
@property (nonatomic,copy) NSString *identifierStr;
@property (nonatomic,copy) NSString *title;
@property (nonatomic,copy) NSString *subtitle;
///固定屏幕点的坐标
@property (nonatomic,assign) CGPoint lockedToScreenPoint;
@property (nonatomic,assign) BOOL needLockedToScreen;
@property (nonatomic,assign) CLLocationDegrees latitude;
@property (nonatomic,assign) CLLocationDegrees longitude;
@property (nonatomic,strong) UIImage * icon;
@property (nonatomic,strong) NSData * iconData;
@property (nonatomic,strong) NSString * iconAppendStr;
@property (nonatomic,strong) UIColor * iconAppendStrColor;
@property (nonatomic,strong) NSDictionary *styleDic;
@property (nonatomic,assign) CGFloat rotate;
@property (nonatomic,assign) CGFloat alpha;
@property (nonatomic,assign) CGFloat width;
@property (nonatomic,assign) CGFloat height;
@property (nonatomic,assign) CGFloat anchorX;
@property (nonatomic,assign) CGFloat anchorY;
@property (nonatomic,strong) UIImage * imageForAnnotation;
@property (nonatomic,strong) UIImage *style4Image;
@property (nonatomic,strong) UIView *animationViewForAnnotaion;
@property (nonatomic,strong) RVMapCallout * callout;
@property (nonatomic,assign) NSInteger markerLevel;

@property (nonatomic,strong) NSArray *displayRanges;
@property (nonatomic,copy) NSString *bottomDescString;
@property (nonatomic,strong) RVMapCommonMapLabel *labelModel;
@property (nonatomic,assign) BOOL clusterEnabled;
@property (nonatomic,strong) NSNumber *rank;  // marker碰撞的优先级
// dsl
@property (nonatomic,strong) NSDictionary *iconLayout;

// customCallout
@property (nonatomic,strong) NSDictionary *bubbleConfig;
@property (nonatomic,strong) RVZebraView *dslLayoutView;
@property (nonatomic,assign) BOOL hiddenBubble;
@property (nonatomic,assign) BOOL isCustomCallout;
@property (nonatomic,assign) NSInteger customCalloutType;
@property (nonatomic,strong) NSString * customCalloutTime;
@property (nonatomic,assign) BOOL customCalloutShouldShow;
@property (nonatomic,assign) BOOL canShowOnTap;
@property (nonatomic,strong) NSArray *descList;
@property (nonatomic,strong) NSArray *subDescList;
@property (nonatomic,assign) CLLocationDirection mapRotationDegree;

- (void)updateAnimationAnnotationWithImage:(UIImage *)image;
- (void)prepareForAnnotation;
- (void)prepareAnimationAnnotationWithData:(NSDictionary *)data;
- (UIImage *)getImageWithStyle4Data:(NSDictionary *)data;

@end

@interface RVMapAnnotation : NSObject <RVMapAnnotationProtocol>


@end
