//
//  RVMAMapMarker.h
//  APMap
//
//  Created by 去疾 on 17/3/28.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>
#import "RVMapAnnotation.h"

@class RVMapMoveMarkerModel;
@class RVMapCallout;
@class RVMapCommonMapLabel;

#if RVMAMAP_2D
@interface RVMAMapMarker : MAPointAnnotation <RVMapAnnotationProtocol>
#else
@interface RVMAMapMarker : MAAnimatedAnnotation <RVMapAnnotationProtocol>
#endif

- (instancetype)initWithMapAnnotationModel:(id<RVMapAnnotationProtocol>)annotation;

- (id)initWithLongitude:(CLLocationDegrees)longitude latitude:(CLLocationDegrees)latitude andIcon:(UIImage*)icon;

//-(void)prepareForAnnotation;

//- (void)prepareAnimationAnnotationWithData:(NSDictionary *)data;

//- (UIImage *)getImageWithStyle4Data:(NSDictionary *)data;

- (void)updateDescLabelWithString:(NSString *)string;

// animate
- (void)addMoveAnimationWithSetting:(RVMapMoveMarkerModel *)setting
                           callback:(RVMAMarkerAniCallback)callback;
- (void)stopMoveAnimation:(RVMAMarkerAniCallback)callback;
- (void)invalidateAnimation;

@end
