//
//  RVKWorkerPreloadProtocol.h
//  AriverKernel
//
//  Created by 岚遥 on 2020/6/2.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AriverKernel/RVKSession.h>

NS_ASSUME_NONNULL_BEGIN

@protocol RVKWorkerPreloadProtocol <NSObject>

/**
 @return 获取预创建的 JSCManager
 */
- (id)preloadJSCManagerWithAppId:(NSString *)appId;

/**
 @param appId 当前小程序的appId
 @return worker预加载是否执行
 */
- (BOOL)workerPreloadedWithAppId:(NSString *)appId;

/**
 @param url worker预加载资源url
 @return 返回worker预加载的数据
 */
- (NSData *)workerPreloadDataForUrl:(NSURL *)url;

/**
 @brief 获取预加载的 bizContext 的 name
 @return workerBizContextName
 */
- (NSString *)nameForWorkerPreloadBizContext;

/**
 @brief 获取 worker 预加载的 Appx JSContext 的 name
 @return appx 预加载的 jscontext name
 */
- (NSString *)nameForWorkerPreloadAppxContext;

/**
 @return worker预加载是否开启
 */
- (BOOL)enableWorkerPreload;

/**
 @return worker 预加载的插件appId
 */
- (NSArray<NSString *> *)workerPreloadPlugins;

@end

NS_ASSUME_NONNULL_END
