//
//  RVKExtendJSApiManager.h
//  AriverKernel
//
//  Created by runfeng.crf on 2020/9/8.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSUInteger, RVKExtendAPIType) {
    RVKExtendAPITypeInvoke,
    RVKExtendAPITypeEvent
};

//端上扩展jsapi/jsevent能力，例如my.tb.xxx这种
@interface RVKExtendJSApiManager : NSObject

+ (instancetype)manager;


//单个注册扩展jsapi
- (void)registerExtendJSApi:(NSString *)name className:(NSString *)cmd domain:(NSString *)nameSpace;
//单个注册js事件
- (void)registerExtendEvent:(NSString *)eventName domain:(NSString *)nameSpace;

/*
* 批量注册扩展api和js事件。格式为：
    @[
        @{
            @"apiName" : @"request",
            @"className" : @"JSApiHandler4Request",
            @"namespace" : @"tb",
            @"type" : @(RVKExtendAPITypeInvoke),
        },
        @{
            @"eventName" : @"pageResume",
            @"namespace" : @"tb",
            @"type" : @(RVKExtendAPITypeEvent)
        }
    ]
*/
- (void)registerExtendJSApis:(NSArray *)config;

- (NSString *)extendJsapiScript;

@end

NS_ASSUME_NONNULL_END
