//
//  PSDInterface.h
//  NebulaPoseidon
//
//  Created by yangwei on 2020/11/4.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@protocol MPMpaaSNSURLConnectionDataDelegate <NSObject>
@optional

// webview ssl正式校验
- (void)connection:(NSURLConnection *)connection willSendRequestForAuthenticationChallenge:(NSURLAuthenticationChallenge *)challenge;

@end

@protocol MPMpaaSWKWebViewLoggerDelegate <NSObject>
@optional

// 拦截WKWebView 的 handlesURLScheme
- (void)doLogWithWebView:(WKWebView*)webview urlScheme:(NSString *)urlScheme;

@end

@interface PSDInterface : NSObject

// 是否调过容器对base64补充content-type的逻辑，默认为NO，即容器默认会补充content-type
@property(nonatomic, assign) BOOL shouldSkipAddBase64ContentTypeWithFormData;

// 是否修复jsapi条件竞争漏洞
@property(nonatomic, assign) BOOL shouldFixFlushMessageQueueSourceUrl;

// 打开上述开关的页面url 字符串数组
@property(nonatomic, strong) NSArray *whiteUrls;

// 是否使用新的js
@property(nonatomic, assign) BOOL shouldUpdateH5MessageChanelJS;

// 是否支持三方 pdf.js
@property(nonatomic, assign) BOOL  shouldSupportPdfJs;

// 是否支持fetch 分段请求
@property(nonatomic, assign) BOOL  shouldSupportFetchStream;

// 设置wkwebview容器权限校验回调delegate。
@property(nonatomic, weak) id<MPMpaaSNSURLConnectionDataDelegate> mPaaSNSURLConnectionDelegate;

@property(nonatomic, weak) id<MPMpaaSWKWebViewLoggerDelegate> mPaaSWKWebViewLoggerDelegate;

+ (instancetype)sharedInstance;

// 是否启用MDC
- (BOOL)mdcEnabled;

// 是否使用MDC下发的IPv6
- (BOOL)mdcIpv6Enabled;

// 是否使用MDC下发的Port
- (BOOL)mdcPortEnabled;

@end

NS_ASSUME_NONNULL_END
