//
//  TAStandardDebugLogger.h
//  TinyAppCommon
//
//  Created by runfeng.crf on 2018/8/28.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AriverKernel/AriverKernel.h>

static NSString * const RVDStandardDebugLogCategoryInfo = @"info";
static NSString * const RVDStandardDebugLogCategoryWarn = @"warn";
static NSString * const RVDStandardDebugLogCategoryError = @"error";

@interface RVDRemoteDebugStandardLogger : NSObject

+ (void)logNetworkInfo:(RVKSession *)session
               request:(NSURLRequest *)request
              response:(NSHTTPURLResponse *)response
          responseData:(NSData *)data
                 error:(NSError *)error
           requestTime:(NSDate *)requestTime;

+ (void)logWithCategory:(NSString *)category
                  logId:(NSString *)logId
                message:(NSString *)message
            description:(NSString *)description
                 output:(NSString *)output
                session:(RVKSession *)context
             completion:(void (^)(BOOL success, NSError *error))completion;

+ (void)logStorageInfo:(RVKSession *)session
                 appId:(NSString *)appId
               dataKey:(NSString *)key;

@end
