//
//  TADebuggerManager.h
//  TinyAppCommon
//
//  Created by 应俊康 on 2018/7/23.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "RVDDebugPanel.h"
#import "RVDPerformancePanel.h"
#import "RVDConsoleBtn.h"
#import "RVDRemoteDebugManager.h"
#import <AriverRuntime/RVTTinyappConfig.h>

@interface RVDDebugManager : NSObject <RVTTinyappDebugDelegate>

@property (nonatomic, weak) RVKSession *currentSession;
@property (nonatomic, strong) RVDRemoteDebugPanel *panel;

+ (NSString *)parentAppIdWithSession:(RVKSession *)session;

+ (BOOL)isDebugPanelWithSession:(RVKSession *)session;

+ (BOOL)isRemoteDebugOpen:(RVKSession *)session;

+ (BOOL)isRemoteDebugOpenByAppId:(NSString *)appId;

-(BOOL)openDebug4App:(NSString*)appId;

-(BOOL)closeDebug4App:(NSString*)appId;

-(BOOL)openPerformance4App:(NSString*)appId;

-(BOOL)closePerformance4App:(NSString*)appId;

- (BOOL)openRemoteDebug4Session:(RVKSession *)session;

- (BOOL)closeRemoteDebug4AppId:(NSString *)appId;

-(BOOL)isAppOpenDebug:(NSString*)appId;

-(BOOL)isAppOpenPerformance:(NSString*)appId;

-(RVDConsoleBtn*)console4AppId:(NSString*)appId;

-(RVDConsoleBtn*)openTest4AppId:(NSString*)appId;

-(RVDPerformancePanel*)performancePanel4AppId:(NSString*)appId;

- (RVDRemoteDebugManager *)remoteDebugManager4AppId:(NSString *)appId;

-(BOOL)evaluateDebugJs4Session:(RVKSession *)session;

- (void)evaluateDebugConsoleJS;

-(void)hideAll4AppId:(NSString *)appId;

- (void)evaluateJSInDebugConsole:(NSString *)appId script:(NSString *)script;

- (void)updateLocalStorageInfo;

#pragma mark - RemoteDebug panel
- (void)showRemoteDebugLinkStatePanel:(RVDRemoteDebugPanelStatus)status labelText:(NSString *)labelText buttonText:(NSString *)buttonText onClick:(void (^)(void))clickAction;
- (void)hideRemoteDebugLinkStatePanel;
- (void)showRemoteDebugMask:(NSString *)message buttonTitle:(NSString *)buttonTitle onClick:(void (^)(void))clickAction;
- (void)hideRemoteDebugMask;

@end

RVDDebugManager * RVDDebugManagerGet();
