//
//  RVDBeaconManager.h
//  RVDBLESDK
//
//  Created by 任飞 on 2017/8/30.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import <CoreLocation/CoreLocation.h>
#import <CoreBluetooth/CoreBluetooth.h>
#import "RVDBLEResultObject.h"
#import "CLBeacon+Identifier.h"

@protocol RVDBeaconEventProtocol <NSObject>
@optional

- (void)onBeaconUpdate:(NSArray<CLBeacon *>*)beacons;

- (void)onBeaconServiceChange:(BOOL)available
                  discovering:(BOOL)discovering;

@end

@interface RVDBeaconManager : NSObject

@property (nonatomic, strong) CBCentralManager *centralManager;
@property (nonatomic, weak) id<RVDBeaconEventProtocol> eventDelegate;
@property (nonatomic,strong) CLLocationManager *locationManager;
@property (nonatomic, assign, readonly) BOOL isDiscovering;
/**
 当前蓝牙是否可用
 */
@property (nonatomic, assign)   BOOL beaconAvailable;

-(RVDBLEResultObject *)startBeaconDiscovery:(NSArray<NSUUID*>*)uuids;
-(RVDBLEResultObject *)stopBeaconDiscovery;
-(NSArray<CLBeacon *>*)getFoundBeacons;
-(void)clearFoundBeacons;
@end
