//
//  RVDBLECentralManager.h
//  RVDBLE
//
//  Created by Ethan on 27/05/2017.
//  Copyright © 2017 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "RVDBLEDeviceInfo.h"
#import "RVDBLEResultObject.h"
#import "RVDBLESemaphoreContext.h"

@class RVDBLECentralManager;

@protocol RVDBLECentralEventProtocol <NSObject>
@optional

- (void)onDiscoverPeriperal:(RVDBLEDeviceInfo *)deviceInfo;

- (void)onDiscoverPeriperals:(NSArray<RVDBLEDeviceInfo *>*)deviceInfos;

- (void)onCentralDidUpdateState;

- (void)onConnectionStateChanged:(CBPeripheral *)peripheral;

- (void)onCharacteristicValueUpdate:(CBCharacteristic *)characteristic;

- (void)onCharacteristicBigValueUpdate:(CBCharacteristic *)characteristic value:(NSString *)value;

@end

@interface RVDBLECentralManager : NSObject
@property (nonatomic, strong)   CBCentralManager    *centralManager;
@property (nonatomic, weak)     id<RVDBLECentralEventProtocol> eventDelegate;

/**
 对于同一外设是否允许重复上报，除RSSI不同，都相同
 */
@property (nonatomic, assign) BOOL allowDuplicatesKey;

@property (nonatomic, assign) NSInteger interval;


/**
 同步获取蓝牙 state
 */
@property (nonatomic, assign)   CBManagerState   state;
/**
 返回关于 state 状态的错误描述文案
 */
@property (nonatomic, copy, readonly)     NSString   *stateErrorMessage;

/**
 当前蓝牙是否可用
 */
@property (nonatomic, assign)   BOOL             bleSupported;
@property (nonatomic, assign)   BOOL             bleAvailable;
@property (nonatomic, assign, readonly)   BOOL   bleScanning;

/**
 蓝牙设备列表
 */
@property (nonatomic, strong, readonly)   NSArray  *discoveredPeripherals;
@property (nonatomic, strong, readonly)   NSArray  *connectedPeripherals;

#pragma mark - BLE Workflow

- (instancetype)initWithEventDelegate:(id<RVDBLECentralEventProtocol>)eventDelegate appId:(NSString *)appId;

-(void)releaseData;
-(void)reset:(id<RVDBLECentralEventProtocol>)eventDelegate;

-(void)startScan:(NSArray *)serviceUUIDs;
-(void)stopScan;
//释放资源（停止扫描、断开连接）
- (void)stopScanAndDisconnect;

-(RVDBLEResultObject *)connectPeripheral:(NSString *)deviceId;
-(RVDBLEResultObject *)connectPeripheral:(NSString *)deviceId timeout:(double)timeout;
-(RVDBLEResultObject *)disconnectPeripheral:(NSString *)deviceId needWait:(BOOL)needWait;

-(NSArray *)discoveredPeripheralsWithServices:(NSArray *)services;
-(NSArray *)connectedPeripheralsWithServices:(NSArray *)services;

-(RVDBLEResultObject *)servicesOfPeripheral:(NSString *)deviceId;
-(RVDBLEResultObject *)characteristicsOfPeripheral:(NSString *)deviceId ofService:(NSString *)serviceId;

-(RVDBLEResultObject *)readCharacteristicValue:(NSString *)deviceId
                                    ofService:(NSString *)serviceId
                             ofCharacteristic:(NSString *)characteristicId;

-(RVDBLEResultObject *)notifyCharacteristicValueChanges:(NSString *)deviceId
                                             ofService:(NSString *)serviceId
                                      ofCharacteristic:(NSString *)characteristicId
                                                notify:(BOOL)notify;

-(RVDBLEResultObject *)writeCharacteristicValue:(id)valueObj
                                      ofDevice:(NSString *)deviceId
                                     ofService:(NSString *)serviceId
                               ofCharacteristic:(NSString *)characteristicId
                                    ofIsBigData:(BOOL)isBigData;

- (RVDBLEResultObject *)readRSSI:(NSString *)deviceId;

#pragma mark - Utils

-(RVDBLEDeviceInfo *)deviceInfoForPeripheral:(NSUUID *)uuid;

@end
