//
//  TAFileUtils.h
//  TinyappService
//
//  Created by 应俊康 on 2017/10/25.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

#define KTA_FM_UsrFileProtocol @"https://usr"
#define KTA_FM_ResourceFileProtocol @"https://resource"

@class PSDContext;
@interface AOMPFileUtils : NSObject

// 小程序用户目录
+ (NSString *)getAppPathWithAppId:(NSString *)appId;

// 小程序缓存目录
+ (NSString *)getAppSavedPathWithAppId:(NSString *)appId;

// 小程序临时目录
+ (NSString *)getAppTempPathWithAppId:(NSString *)appId;

// 本地多媒体目录
+ (NSString *)getMutilMediaFilePath;

// 代码目录
+ (NSString *)getAppTarPathWithAppId:(NSString *)appId DEPRECATED_MSG_ATTRIBUTE("该方法获取不准确，请使用getAppTarPathWithContext:");

// 小程序代码目录
+ (NSString *)getAppTarPathWithContext:(PSDContext *)context;

+ (float)fileSizeAtPath:(NSString*)path;

+ (float)folderSizeAtPath:(NSString*)path;

+ (NSData *)fileDataWithApFilePath:(NSString *)apFilePath appId:(NSString*)appId;

+ (NSData *)fileDataWithApFilePath:(NSString *)apFilePath protocol:(NSString *)protocol appId:(NSString*)appId;

+ (NSData *)fileDataWithTempFilePath:(NSString *)tempFilePath appId:(NSString*)appId;

+ (NSData *)createInsideHttpDataWithLocalId:(NSString *)localId type:(NSString *)type;
/**
 根据usr 虚拟路径获取文件内容

 @param usrFilePath https://usr开头的虚拟地址
 @param appId 对应的APPID
 */
+ (NSData *)fileDataWithUsrFilePath:(NSString *)usrFilePath appId:(NSString *)appId;


+ (NSString *)fileTypeWithApFilePath:(NSString *)apFilePath appId:(NSString*)appId;

// 判断是否用户目录地址
+ (BOOL)isUsrUrl:(NSString *)url;

// 生成用户文件虚拟地址
+ (NSString *)createUsrUrlWithLocalId:(NSString *)localId type:(NSString *)type;

// 物理地址 & 虚拟地址互转
+ (NSString *)getMapRelationVal:(NSString *)key;

// 获取物理地址用户文件虚拟地址
+ (NSString *)getLocalURLWithAppId:(NSString *)appId path:(NSString *)path DEPRECATED_MSG_ATTRIBUTE("该方法获取不准确，请使用getLocalURLWithAppId:path:context:");

+ (NSString *)getLocalURLWithAppId:(NSString *)appId path:(NSString *)path context:(PSDContext *)context;

/// 根据localPath获取多媒体播放的cloudid或者文件地址
/// @param appId
/// @param path localPath
+ (NSString *)getMediaLocalURLWithAppId:(NSString *)appId path:(NSString *)path;

// 是否可写
+ (BOOL)canWriteWithWithAppId:(NSString *)appId path:(NSString *)path;

// 是否可读
+ (BOOL)canReadWithWithAppId:(NSString *)appId path:(NSString *)path DEPRECATED_MSG_ATTRIBUTE("该方法获取不准确，请使用canReadWithWithAppId:path:context:");

+ (BOOL)canReadWithWithAppId:(NSString *)appId path:(NSString *)path context:(PSDContext *)context;

// 防止穿越
+ (BOOL)hasDirTraversalWithPath:(NSString *)path;

// 判断 tar 路径是否不可访问
+ (BOOL)isTarPathInBlackList:(NSString *)path;

// 编码映射
+ (NSStringEncoding)getEncodingType:(NSString *)encoding;

//
+ (NSStringEncoding)getEncodingType:(NSString *)encoding
                    defaultEncoding:(NSStringEncoding)defaultEncoding;

// 字符串转16进制字符串
+ (NSString *)stringToHexStr:(NSString *)string;

// 16进制字符串转字符串
+ (NSString *)hexStrToString:(NSString *)hexStr;

// NSData实例转化为hex string
+ (NSString *)dataToHexStr:(NSData *)data;

// 根据tarPath来获取当前的内容
+ (id)getTarPathContentWithContext:(PSDContext *)context
                           tarPath:(NSString *)tarPath
                           keyPath:(NSString *)keyPath;
//获取包内容
+ (id)getTarPathContentFromDataSource:(NAMAppDataSource *)dataSource
                              tarPath:(NSString *)tarPath
                              keyPath:(NSString *)keyPath;

//根据APFilePath  从多媒体获取文件信息
+ (NSData *)multimediaDataWithApfilePath:(NSString *)apFilePath;

//获取多媒体的文件地址
+ (NSString *)getMediaTempFileAbsolutePath:(NSString *)url;

#pragma mark - 待删除
+ (BOOL)isReadFileCallbackArrayBuffer;

@end
