 //
//  UIView+AUKExtend.h
//  AntUIKit
//
//  Created by niki on 2019/12/17.
//  Copyright © 2019 Alipay. All rights reserved.
//


#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

// 采集事件类型
typedef NS_ENUM(NSInteger, AUKEventType) {
    AUKEventTypeExposure = 0,  // 曝光
    AUKEventTypeClick = 1,     // 点击
    AUKEventTypeScroll = 2,    // 滚动
    AUKEventTypeInput = 3,     // 输入
};

typedef NS_ENUM(NSInteger, AUKExposureState) {
    AUKExposureStateNone = 0,   // 默认
    AUKExposureStateStart = 1,  // 曝光开始
    AUKExposureStateEnd = 2     // 曝光结束
};

@class UEPExposureItem;

@interface AUKEventLogModel : NSObject

@property (nonatomic, strong) NSString *spm_auk;          // 位置标识
@property (nonatomic, strong) NSString *scm_auk;          // 内容标识
@property (nonatomic, strong) NSDictionary *extParam_auk; // spm的扩展内容(k-v扩展参数)
@property (nonatomic, strong) NSString *eventId_auk;      // 业务schema化扩展参数，选填
@property (nonatomic, strong) NSData *eventInfo_auk;      // 业务schema化扩展参数，选填
@property (nonatomic, strong) NSString *bizCode_auk;      // 业务标识
@property (nonatomic, strong) NSString *entityId_auk;     // 业务控件标识，选填参数
@property (nonatomic, assign) BOOL closeExpose_auk;       // 控制参数，关闭控件曝光事件，选填参数，默认NO
@property (nonatomic, assign) BOOL addManualSpm_auk;      // 是否添加手动埋点，默认NO
@property (nonatomic, assign) float areaShowPercent_auk;  // 控件显示有效区域比例，范围（0,1]，默认1

// 强制上报页面埋点：case1:若绑定在VC上忽略VC是否在页面栈的检查， case2:若绑定在view上，向上找nextResponser到第一个VC，并把view的把LogModel绑定到此VC,再按case1处理
@property (nonatomic, assign) BOOL forceReportPage;

// 在进入前后台时，父子页面页面互斥上报，默认NO都上报
@property (nonatomic, assign) BOOL mutexReportParentWithSubPage;

// 解决特殊场景无法感知控件消失情况，要求控件释放和消失同时触发才可使用
@property (nonatomic, assign) BOOL exposeEndWhenRelease;  // 控件释放时，触发曝光结束事件，默认NO

@property (nonatomic, strong) NSDictionary *sdkParam_auk; // 框架采集扩展参数，与业务扩展参数隔离

/*
   批量曝光设置接口。注意：
    1、d位调用该接口无效；
    2、绑定d位有其它需求（如点击）需要设置model，则设置closeExpose_auk=YES，避免曝光；
 */
@property (nonatomic, strong) NSArray<UEPExposureItem *> *exposureItems_auk;
@property (nonatomic, assign) BOOL updateExposureItems_auk;

// 已废弃
@property (nonatomic, strong) NSString *spmId_auk DEPRECATED_MSG_ATTRIBUTE("已废弃，请使用 spm_auk");
@property (nonatomic, strong) NSDictionary *extInfo_auk DEPRECATED_MSG_ATTRIBUTE("已废弃，请使用 extParam_auk");
@property (nonatomic, strong) NSData *bizInfo_auk DEPRECATED_MSG_ATTRIBUTE("已废弃，请使用 eventInfo_auk");

@end

// model: 已有的埋点数据模型，空模型即可。
// eventType: 事件类型，AUKEventType
// 得到的更新信息不覆盖原有的基础信息。
typedef void (^AUKEventLogUpdateBlock)(AUKEventLogModel *model, AUKEventType eventType);

//
@interface UIView (AUKExtend)

@property(nonatomic, assign) BOOL existExposureAspect;

// 设置spm信息
- (void)setupEventLog_auk:(void(^)(AUKEventLogModel*model))block;

// 设置更新埋点信息的block，延迟更新，事件发生时再调用
// 在埋点上报前会执行以下block再合并之前设置好的埋点信息，主要用于埋点信息需要等待特定逻辑的场景
// 注意：仅设置参数，切勿执行耗时逻辑
- (void)setupEventLogUpdateBlock_auk:(AUKEventLogUpdateBlock)block;

// 解绑已设置的埋点模型 及 延迟更新block
- (void)unbindEventLog_auk;

// 业务手动补充
- (void)visibilityChanged_auk;

// 仅在特别版绑定视图spm值，非特别版不生效
- (void)setupVisDataSpm_auk:(NSString *)spm;

// 是否忽略点击采集，默认是否
- (void)setSkipClick_auk:(BOOL)skip;

// spmInfo
//    NSString spm;
//    NSString scm;
//    NSString bizCode;
//    NSDictionary<String, String> params;
//    其它参数：参考eventLogModel_auk属性，对应key为属性去掉_auk后缀
// context
//    NSNumber exposureState:曝光状态，1（开始），其他值（结束）
- (void)executeUEPExposureEvent_auk:(NSDictionary *)spmInfo context:(NSDictionary *)context;

// 需要self.eventLogModel_auk已经绑定数据
// context：  NSNumber exposureState:曝光状态，1（开始），其他值（结束）
- (void)executeUEPExposureEvent_auk:(NSDictionary *)context;


// spmInfo
//    NSString spm;
//    NSString scm;
//    NSString bizCode;
//    NSDictionary<String, String> params;
// context
//    NSInteger text:控件title
- (void)executeUEPClickEvent_auk:(NSDictionary *)spmInfo context:(NSDictionary *)context;

// 主动触发点击，使用绑定模型数据
- (void)executeUEPClickEvent_auk;

/*
 * spmInfo
 * NSString spm;
 * NSString scm;
 * NSDictionary<String, String> params;
 *
 * context
 * NSString promptType; toast/alert/notice
 * NSString title
 * NSString promptMsg 
 * NSString category; 分类：xxxDialog
 * NSArray<NSString *> buttons; 按钮标题
 */
- (void)executeUEPPromptEvent_auk:(NSDictionary *)spmInfo context:(NSDictionary *)context;

@end

NS_ASSUME_NONNULL_END
